/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputCheckPasswordSRP;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.DeleteAccount;

public final class ImmutableDeleteAccount
implements DeleteAccount {
    private final int identifier;
    private final int flags;
    private final String reason;
    @Nullable
    private final InputCheckPasswordSRP password;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDeleteAccount(String reason) {
        this.reason = Objects.requireNonNull(reason, "reason");
        this.password = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableDeleteAccount(Builder builder) {
        this.reason = builder.reason;
        this.password = builder.password;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableDeleteAccount(int identifier, int flags, String reason, @Nullable InputCheckPasswordSRP password) {
        this.identifier = identifier;
        this.flags = flags;
        this.reason = reason;
        this.password = password;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DeleteAccount.super.identifier();
    }

    private int flagsInitialize() {
        return DeleteAccount.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    @Nullable
    public InputCheckPasswordSRP password() {
        return this.password;
    }

    public final ImmutableDeleteAccount withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDeleteAccount(value, this.flags, this.reason, this.password);
    }

    public final ImmutableDeleteAccount withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDeleteAccount(this.identifier, value, this.reason, this.password);
    }

    public final ImmutableDeleteAccount withReason(String value) {
        String newValue = Objects.requireNonNull(value, "reason");
        if (this.reason.equals(newValue)) {
            return this;
        }
        return new ImmutableDeleteAccount(this.identifier, this.flags, newValue, this.password);
    }

    public final ImmutableDeleteAccount withPassword(@Nullable InputCheckPasswordSRP value) {
        if (this.password == value) {
            return this;
        }
        return new ImmutableDeleteAccount(this.identifier, this.flags, this.reason, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteAccount && this.equalTo(0, (ImmutableDeleteAccount)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeleteAccount another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.reason.equals(another.reason) && Objects.equals(this.password, another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.reason.hashCode();
        h += (h << 5) + Objects.hashCode(this.password);
        return h;
    }

    public String toString() {
        return "DeleteAccount{identifier=" + this.identifier + ", flags=" + this.flags + ", reason=" + this.reason + ", password=" + this.password + "}";
    }

    public static ImmutableDeleteAccount of(String reason) {
        return new ImmutableDeleteAccount(reason);
    }

    public static ImmutableDeleteAccount copyOf(DeleteAccount instance) {
        if (instance instanceof ImmutableDeleteAccount) {
            return (ImmutableDeleteAccount)instance;
        }
        return ImmutableDeleteAccount.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_REASON = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private String reason;
        private InputCheckPasswordSRP password;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DeleteAccount instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DeleteAccount) {
                instance = (DeleteAccount)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reason(instance.reason());
                InputCheckPasswordSRP passwordValue = instance.password();
                if (passwordValue != null) {
                    this.password(passwordValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder reason(String reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder password(@Nullable InputCheckPasswordSRP password) {
            this.password = password;
            return this;
        }

        public ImmutableDeleteAccount build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeleteAccount(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reason");
            }
            return "Cannot build DeleteAccount, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDeleteAccount.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDeleteAccount.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build DeleteAccount, attribute initializers form cycle " + attributes;
        }
    }
}

