/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetAccountTTL;

public final class ImmutableGetAccountTTL
implements GetAccountTTL {
    private final int identifier;
    private static final ImmutableGetAccountTTL INSTANCE = ImmutableGetAccountTTL.validate(new ImmutableGetAccountTTL());

    private ImmutableGetAccountTTL() {
        this.identifier = GetAccountTTL.super.identifier();
    }

    private ImmutableGetAccountTTL(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetAccountTTL.super.identifier();
    }

    private ImmutableGetAccountTTL(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableGetAccountTTL withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableGetAccountTTL.validate(new ImmutableGetAccountTTL(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetAccountTTL && this.equalTo(0, (ImmutableGetAccountTTL)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetAccountTTL another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "GetAccountTTL{identifier=" + this.identifier + "}";
    }

    public static ImmutableGetAccountTTL of() {
        return INSTANCE;
    }

    private static ImmutableGetAccountTTL validate(ImmutableGetAccountTTL instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableGetAccountTTL copyOf(GetAccountTTL instance) {
        if (instance instanceof ImmutableGetAccountTTL) {
            return (ImmutableGetAccountTTL)instance;
        }
        return ImmutableGetAccountTTL.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetAccountTTL instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetAccountTTL) {
                instance = (GetAccountTTL)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableGetAccountTTL build() {
            return ImmutableGetAccountTTL.validate(new ImmutableGetAccountTTL(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

