/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetAuthorizationForm;

public final class ImmutableGetAuthorizationForm
implements GetAuthorizationForm {
    private final int identifier;
    private final long botId;
    private final String scope;
    private final String publicKey;

    private ImmutableGetAuthorizationForm(long botId, String scope, String publicKey) {
        this.botId = botId;
        this.scope = Objects.requireNonNull(scope, "scope");
        this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
        this.identifier = GetAuthorizationForm.super.identifier();
    }

    private ImmutableGetAuthorizationForm(Builder builder) {
        this.botId = builder.botId;
        this.scope = builder.scope;
        this.publicKey = builder.publicKey;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetAuthorizationForm.super.identifier();
    }

    private ImmutableGetAuthorizationForm(int identifier, long botId, String scope, String publicKey) {
        this.identifier = identifier;
        this.botId = botId;
        this.scope = scope;
        this.publicKey = publicKey;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long botId() {
        return this.botId;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public String publicKey() {
        return this.publicKey;
    }

    public final ImmutableGetAuthorizationForm withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetAuthorizationForm(value, this.botId, this.scope, this.publicKey);
    }

    public final ImmutableGetAuthorizationForm withBotId(long value) {
        if (this.botId == value) {
            return this;
        }
        return new ImmutableGetAuthorizationForm(this.identifier, value, this.scope, this.publicKey);
    }

    public final ImmutableGetAuthorizationForm withScope(String value) {
        String newValue = Objects.requireNonNull(value, "scope");
        if (this.scope.equals(newValue)) {
            return this;
        }
        return new ImmutableGetAuthorizationForm(this.identifier, this.botId, newValue, this.publicKey);
    }

    public final ImmutableGetAuthorizationForm withPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "publicKey");
        if (this.publicKey.equals(newValue)) {
            return this;
        }
        return new ImmutableGetAuthorizationForm(this.identifier, this.botId, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetAuthorizationForm && this.equalTo(0, (ImmutableGetAuthorizationForm)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetAuthorizationForm another) {
        return this.identifier == another.identifier && this.botId == another.botId && this.scope.equals(another.scope) && this.publicKey.equals(another.publicKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.botId);
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.publicKey.hashCode();
        return h;
    }

    public String toString() {
        return "GetAuthorizationForm{identifier=" + this.identifier + ", botId=" + this.botId + ", scope=" + this.scope + ", publicKey=" + this.publicKey + "}";
    }

    public static ImmutableGetAuthorizationForm of(long botId, String scope, String publicKey) {
        return new ImmutableGetAuthorizationForm(botId, scope, publicKey);
    }

    public static ImmutableGetAuthorizationForm copyOf(GetAuthorizationForm instance) {
        if (instance instanceof ImmutableGetAuthorizationForm) {
            return (ImmutableGetAuthorizationForm)instance;
        }
        return ImmutableGetAuthorizationForm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT_ID = 1L;
        private static final long INIT_BIT_SCOPE = 2L;
        private static final long INIT_BIT_PUBLIC_KEY = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long botId;
        private String scope;
        private String publicKey;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetAuthorizationForm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetAuthorizationForm) {
                instance = (GetAuthorizationForm)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.botId(instance.botId());
                this.publicKey(instance.publicKey());
                this.scope(instance.scope());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder botId(long botId) {
            this.botId = botId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder scope(String scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder publicKey(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetAuthorizationForm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetAuthorizationForm(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("botId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scope");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("publicKey");
            }
            return "Cannot build GetAuthorizationForm, some of required attributes are not set " + attributes;
        }
    }
}

