/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputWallPaper;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetMultiWallPapers;

public final class ImmutableGetMultiWallPapers
implements GetMultiWallPapers {
    private final int identifier;
    private final List<InputWallPaper> wallpapers;

    private ImmutableGetMultiWallPapers(Builder builder) {
        this.wallpapers = ImmutableGetMultiWallPapers.createUnmodifiableList(true, builder.wallpapers);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetMultiWallPapers.super.identifier();
    }

    private ImmutableGetMultiWallPapers(int identifier, List<InputWallPaper> wallpapers) {
        this.identifier = identifier;
        this.wallpapers = wallpapers;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<InputWallPaper> wallpapers() {
        return this.wallpapers;
    }

    public final ImmutableGetMultiWallPapers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetMultiWallPapers(value, this.wallpapers);
    }

    public final ImmutableGetMultiWallPapers withWallpapers(InputWallPaper ... elements) {
        List<InputWallPaper> newValue = ImmutableGetMultiWallPapers.createUnmodifiableList(false, ImmutableGetMultiWallPapers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetMultiWallPapers(this.identifier, newValue);
    }

    public final ImmutableGetMultiWallPapers withWallpapers(Iterable<? extends InputWallPaper> elements) {
        if (this.wallpapers == elements) {
            return this;
        }
        List<InputWallPaper> newValue = ImmutableGetMultiWallPapers.createUnmodifiableList(false, ImmutableGetMultiWallPapers.createSafeList(elements, true, false));
        return new ImmutableGetMultiWallPapers(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetMultiWallPapers && this.equalTo(0, (ImmutableGetMultiWallPapers)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetMultiWallPapers another) {
        return this.identifier == another.identifier && this.wallpapers.equals(another.wallpapers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.wallpapers.hashCode();
        return h;
    }

    public String toString() {
        return "GetMultiWallPapers{identifier=" + this.identifier + ", wallpapers=" + this.wallpapers + "}";
    }

    public static ImmutableGetMultiWallPapers copyOf(GetMultiWallPapers instance) {
        if (instance instanceof ImmutableGetMultiWallPapers) {
            return (ImmutableGetMultiWallPapers)instance;
        }
        return ImmutableGetMultiWallPapers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<InputWallPaper> wallpapers = new ArrayList<InputWallPaper>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetMultiWallPapers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetMultiWallPapers) {
                instance = (GetMultiWallPapers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllWallpapers(instance.wallpapers());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addWallpaper(InputWallPaper element) {
            this.wallpapers.add(Objects.requireNonNull(element, "wallpapers element"));
            return this;
        }

        public final Builder addWallpapers(InputWallPaper ... elements) {
            for (InputWallPaper element : elements) {
                this.wallpapers.add(Objects.requireNonNull(element, "wallpapers element"));
            }
            return this;
        }

        public final Builder wallpapers(Iterable<? extends InputWallPaper> elements) {
            this.wallpapers.clear();
            return this.addAllWallpapers(elements);
        }

        public final Builder addAllWallpapers(Iterable<? extends InputWallPaper> elements) {
            for (InputWallPaper inputWallPaper : elements) {
                this.wallpapers.add(Objects.requireNonNull(inputWallPaper, "wallpapers element"));
            }
            return this;
        }

        public ImmutableGetMultiWallPapers build() {
            return new ImmutableGetMultiWallPapers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

