/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputNotifyPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetNotifyExceptions;

public final class ImmutableGetNotifyExceptions
implements GetNotifyExceptions {
    private final int identifier;
    private final int flags;
    private final boolean compareSound;
    @Nullable
    private final InputNotifyPeer peer;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableGetNotifyExceptions INSTANCE = ImmutableGetNotifyExceptions.validate(new ImmutableGetNotifyExceptions());

    private ImmutableGetNotifyExceptions() {
        this.peer = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.compareSound = this.initShim.compareSound();
        this.initShim = null;
    }

    private ImmutableGetNotifyExceptions(Builder builder) {
        this.peer = builder.peer;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.compareSoundIsSet()) {
            this.initShim.compareSound(builder.compareSound);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.compareSound = this.initShim.compareSound();
        this.initShim = null;
    }

    private ImmutableGetNotifyExceptions(int identifier, int flags, boolean compareSound, @Nullable InputNotifyPeer peer) {
        this.identifier = identifier;
        this.flags = flags;
        this.compareSound = compareSound;
        this.peer = peer;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GetNotifyExceptions.super.identifier();
    }

    private int flagsInitialize() {
        return GetNotifyExceptions.super.flags();
    }

    private boolean compareSoundInitialize() {
        return GetNotifyExceptions.super.compareSound();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean compareSound() {
        InitShim shim = this.initShim;
        return shim != null ? shim.compareSound() : this.compareSound;
    }

    @Override
    @Nullable
    public InputNotifyPeer peer() {
        return this.peer;
    }

    public final ImmutableGetNotifyExceptions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableGetNotifyExceptions.validate(new ImmutableGetNotifyExceptions(value, this.flags, this.compareSound, this.peer));
    }

    public final ImmutableGetNotifyExceptions withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableGetNotifyExceptions.validate(new ImmutableGetNotifyExceptions(this.identifier, value, this.compareSound, this.peer));
    }

    public final ImmutableGetNotifyExceptions withCompareSound(boolean value) {
        if (this.compareSound == value) {
            return this;
        }
        return ImmutableGetNotifyExceptions.validate(new ImmutableGetNotifyExceptions(this.identifier, this.flags, value, this.peer));
    }

    public final ImmutableGetNotifyExceptions withPeer(@Nullable InputNotifyPeer value) {
        if (this.peer == value) {
            return this;
        }
        return ImmutableGetNotifyExceptions.validate(new ImmutableGetNotifyExceptions(this.identifier, this.flags, this.compareSound, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetNotifyExceptions && this.equalTo(0, (ImmutableGetNotifyExceptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetNotifyExceptions another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.compareSound == another.compareSound && Objects.equals(this.peer, another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.compareSound);
        h += (h << 5) + Objects.hashCode(this.peer);
        return h;
    }

    public String toString() {
        return "GetNotifyExceptions{identifier=" + this.identifier + ", flags=" + this.flags + ", compareSound=" + this.compareSound + ", peer=" + this.peer + "}";
    }

    public static ImmutableGetNotifyExceptions of() {
        return INSTANCE;
    }

    private static ImmutableGetNotifyExceptions validate(ImmutableGetNotifyExceptions instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableGetNotifyExceptions copyOf(GetNotifyExceptions instance) {
        if (instance instanceof ImmutableGetNotifyExceptions) {
            return (ImmutableGetNotifyExceptions)instance;
        }
        return ImmutableGetNotifyExceptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_COMPARE_SOUND = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean compareSound;
        private InputNotifyPeer peer;

        private Builder() {
        }

        public final Builder from(GetNotifyExceptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetNotifyExceptions instance;
            long bits = 0L;
            if (object instanceof GetNotifyExceptions) {
                instance = (GetNotifyExceptions)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.compareSound(instance.compareSound());
                InputNotifyPeer peerValue = instance.peer();
                if (peerValue != null) {
                    this.peer(peerValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder compareSound(boolean compareSound) {
            this.compareSound = compareSound;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(@Nullable InputNotifyPeer peer) {
            this.peer = peer;
            return this;
        }

        public ImmutableGetNotifyExceptions build() {
            return ImmutableGetNotifyExceptions.validate(new ImmutableGetNotifyExceptions(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean compareSoundIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte compareSoundBuildStage = 0;
        private boolean compareSound;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGetNotifyExceptions.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableGetNotifyExceptions.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean compareSound() {
            if (this.compareSoundBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.compareSoundBuildStage == 0) {
                this.compareSoundBuildStage = (byte)-1;
                this.compareSound = ImmutableGetNotifyExceptions.this.compareSoundInitialize();
                this.compareSoundBuildStage = 1;
            }
            return this.compareSound;
        }

        void compareSound(boolean compareSound) {
            this.compareSound = compareSound;
            this.compareSoundBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.compareSoundBuildStage == -1) {
                attributes.add("compareSound");
            }
            return "Cannot build GetNotifyExceptions, attribute initializers form cycle " + attributes;
        }
    }
}

