/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputNotifyPeer;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetNotifySettings;

public final class ImmutableGetNotifySettings
implements GetNotifySettings {
    private final int identifier;
    private final InputNotifyPeer peer;

    private ImmutableGetNotifySettings(InputNotifyPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = GetNotifySettings.super.identifier();
    }

    private ImmutableGetNotifySettings(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetNotifySettings.super.identifier();
    }

    private ImmutableGetNotifySettings(int identifier, InputNotifyPeer peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputNotifyPeer peer() {
        return this.peer;
    }

    public final ImmutableGetNotifySettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetNotifySettings(value, this.peer);
    }

    public final ImmutableGetNotifySettings withPeer(InputNotifyPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputNotifyPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableGetNotifySettings(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetNotifySettings && this.equalTo(0, (ImmutableGetNotifySettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetNotifySettings another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "GetNotifySettings{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableGetNotifySettings of(InputNotifyPeer peer) {
        return new ImmutableGetNotifySettings(peer);
    }

    public static ImmutableGetNotifySettings copyOf(GetNotifySettings instance) {
        if (instance instanceof ImmutableGetNotifySettings) {
            return (ImmutableGetNotifySettings)instance;
        }
        return ImmutableGetNotifySettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputNotifyPeer peer;

        private Builder() {
        }

        public final Builder from(GetNotifySettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetNotifySettings instance;
            long bits = 0L;
            if (object instanceof GetNotifySettings) {
                instance = (GetNotifySettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputNotifyPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetNotifySettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetNotifySettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build GetNotifySettings, some of required attributes are not set " + attributes;
        }
    }
}

