/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputCheckPasswordSRP;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetPasswordSettings;

public final class ImmutableGetPasswordSettings
implements GetPasswordSettings {
    private final int identifier;
    private final InputCheckPasswordSRP password;

    private ImmutableGetPasswordSettings(InputCheckPasswordSRP password) {
        this.password = Objects.requireNonNull(password, "password");
        this.identifier = GetPasswordSettings.super.identifier();
    }

    private ImmutableGetPasswordSettings(Builder builder) {
        this.password = builder.password;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetPasswordSettings.super.identifier();
    }

    private ImmutableGetPasswordSettings(int identifier, InputCheckPasswordSRP password) {
        this.identifier = identifier;
        this.password = password;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputCheckPasswordSRP password() {
        return this.password;
    }

    public final ImmutableGetPasswordSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetPasswordSettings(value, this.password);
    }

    public final ImmutableGetPasswordSettings withPassword(InputCheckPasswordSRP value) {
        if (this.password == value) {
            return this;
        }
        InputCheckPasswordSRP newValue = Objects.requireNonNull(value, "password");
        return new ImmutableGetPasswordSettings(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetPasswordSettings && this.equalTo(0, (ImmutableGetPasswordSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetPasswordSettings another) {
        return this.identifier == another.identifier && this.password.equals(another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.password.hashCode();
        return h;
    }

    public String toString() {
        return "GetPasswordSettings{identifier=" + this.identifier + ", password=" + this.password + "}";
    }

    public static ImmutableGetPasswordSettings of(InputCheckPasswordSRP password) {
        return new ImmutableGetPasswordSettings(password);
    }

    public static ImmutableGetPasswordSettings copyOf(GetPasswordSettings instance) {
        if (instance instanceof ImmutableGetPasswordSettings) {
            return (ImmutableGetPasswordSettings)instance;
        }
        return ImmutableGetPasswordSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PASSWORD = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputCheckPasswordSRP password;

        private Builder() {
        }

        public final Builder from(GetPasswordSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetPasswordSettings instance;
            long bits = 0L;
            if (object instanceof GetPasswordSettings) {
                instance = (GetPasswordSettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.password(instance.password());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder password(InputCheckPasswordSRP password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetPasswordSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetPasswordSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build GetPasswordSettings, some of required attributes are not set " + attributes;
        }
    }
}

