/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPrivacyKey;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetPrivacy;

public final class ImmutableGetPrivacy
implements GetPrivacy {
    private final int identifier;
    private final InputPrivacyKey key;

    private ImmutableGetPrivacy(InputPrivacyKey key) {
        this.key = Objects.requireNonNull(key, "key");
        this.identifier = GetPrivacy.super.identifier();
    }

    private ImmutableGetPrivacy(Builder builder) {
        this.key = builder.key;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetPrivacy.super.identifier();
    }

    private ImmutableGetPrivacy(int identifier, InputPrivacyKey key) {
        this.identifier = identifier;
        this.key = key;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPrivacyKey key() {
        return this.key;
    }

    public final ImmutableGetPrivacy withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetPrivacy(value, this.key);
    }

    public final ImmutableGetPrivacy withKey(InputPrivacyKey value) {
        InputPrivacyKey newValue = Objects.requireNonNull(value, "key");
        if (this.key == newValue) {
            return this;
        }
        return new ImmutableGetPrivacy(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetPrivacy && this.equalTo(0, (ImmutableGetPrivacy)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetPrivacy another) {
        return this.identifier == another.identifier && this.key.equals((Object)another.key);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.key.hashCode();
        return h;
    }

    public String toString() {
        return "GetPrivacy{identifier=" + this.identifier + ", key=" + this.key + "}";
    }

    public static ImmutableGetPrivacy of(InputPrivacyKey key) {
        return new ImmutableGetPrivacy(key);
    }

    public static ImmutableGetPrivacy copyOf(GetPrivacy instance) {
        if (instance instanceof ImmutableGetPrivacy) {
            return (ImmutableGetPrivacy)instance;
        }
        return ImmutableGetPrivacy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPrivacyKey key;

        private Builder() {
        }

        public final Builder from(GetPrivacy instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetPrivacy instance;
            long bits = 0L;
            if (object instanceof GetPrivacy) {
                instance = (GetPrivacy)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.key(instance.key());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder key(InputPrivacyKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetPrivacy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetPrivacy(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build GetPrivacy, some of required attributes are not set " + attributes;
        }
    }
}

