/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.SecureValueType;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetSecureValue;

public final class ImmutableGetSecureValue
implements GetSecureValue {
    private final int identifier;
    private final List<SecureValueType> types;

    private ImmutableGetSecureValue(Builder builder) {
        this.types = ImmutableGetSecureValue.createUnmodifiableList(true, builder.types);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetSecureValue.super.identifier();
    }

    private ImmutableGetSecureValue(int identifier, List<SecureValueType> types) {
        this.identifier = identifier;
        this.types = types;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<SecureValueType> types() {
        return this.types;
    }

    public final ImmutableGetSecureValue withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetSecureValue(value, this.types);
    }

    public final ImmutableGetSecureValue withTypes(SecureValueType ... elements) {
        List<SecureValueType> newValue = ImmutableGetSecureValue.createUnmodifiableList(false, ImmutableGetSecureValue.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGetSecureValue(this.identifier, newValue);
    }

    public final ImmutableGetSecureValue withTypes(Iterable<? extends SecureValueType> elements) {
        if (this.types == elements) {
            return this;
        }
        List<SecureValueType> newValue = ImmutableGetSecureValue.createUnmodifiableList(false, ImmutableGetSecureValue.createSafeList(elements, true, false));
        return new ImmutableGetSecureValue(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetSecureValue && this.equalTo(0, (ImmutableGetSecureValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetSecureValue another) {
        return this.identifier == another.identifier && this.types.equals(another.types);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.types.hashCode();
        return h;
    }

    public String toString() {
        return "GetSecureValue{identifier=" + this.identifier + ", types=" + this.types + "}";
    }

    public static ImmutableGetSecureValue copyOf(GetSecureValue instance) {
        if (instance instanceof ImmutableGetSecureValue) {
            return (ImmutableGetSecureValue)instance;
        }
        return ImmutableGetSecureValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<SecureValueType> types = new ArrayList<SecureValueType>();

        private Builder() {
        }

        public final Builder from(GetSecureValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetSecureValue instance;
            long bits = 0L;
            if (object instanceof GetSecureValue) {
                instance = (GetSecureValue)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllTypes(instance.types());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addType(SecureValueType element) {
            this.types.add(Objects.requireNonNull(element, "types element"));
            return this;
        }

        public final Builder addTypes(SecureValueType ... elements) {
            for (SecureValueType element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public final Builder types(Iterable<? extends SecureValueType> elements) {
            this.types.clear();
            return this.addAllTypes(elements);
        }

        public final Builder addAllTypes(Iterable<? extends SecureValueType> elements) {
            for (SecureValueType secureValueType : elements) {
                this.types.add(Objects.requireNonNull(secureValueType, "types element"));
            }
            return this;
        }

        public ImmutableGetSecureValue build() {
            return new ImmutableGetSecureValue(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

