/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputTheme;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetTheme;

public final class ImmutableGetTheme
implements GetTheme {
    private final int identifier;
    private final String format;
    private final InputTheme theme;
    private final long documentId;

    private ImmutableGetTheme(String format, InputTheme theme, long documentId) {
        this.format = Objects.requireNonNull(format, "format");
        this.theme = Objects.requireNonNull(theme, "theme");
        this.documentId = documentId;
        this.identifier = GetTheme.super.identifier();
    }

    private ImmutableGetTheme(Builder builder) {
        this.format = builder.format;
        this.theme = builder.theme;
        this.documentId = builder.documentId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetTheme.super.identifier();
    }

    private ImmutableGetTheme(int identifier, String format, InputTheme theme, long documentId) {
        this.identifier = identifier;
        this.format = format;
        this.theme = theme;
        this.documentId = documentId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public InputTheme theme() {
        return this.theme;
    }

    @Override
    public long documentId() {
        return this.documentId;
    }

    public final ImmutableGetTheme withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetTheme(value, this.format, this.theme, this.documentId);
    }

    public final ImmutableGetTheme withFormat(String value) {
        String newValue = Objects.requireNonNull(value, "format");
        if (this.format.equals(newValue)) {
            return this;
        }
        return new ImmutableGetTheme(this.identifier, newValue, this.theme, this.documentId);
    }

    public final ImmutableGetTheme withTheme(InputTheme value) {
        if (this.theme == value) {
            return this;
        }
        InputTheme newValue = Objects.requireNonNull(value, "theme");
        return new ImmutableGetTheme(this.identifier, this.format, newValue, this.documentId);
    }

    public final ImmutableGetTheme withDocumentId(long value) {
        if (this.documentId == value) {
            return this;
        }
        return new ImmutableGetTheme(this.identifier, this.format, this.theme, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetTheme && this.equalTo(0, (ImmutableGetTheme)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetTheme another) {
        return this.identifier == another.identifier && this.format.equals(another.format) && this.theme.equals(another.theme) && this.documentId == another.documentId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.format.hashCode();
        h += (h << 5) + this.theme.hashCode();
        h += (h << 5) + Long.hashCode(this.documentId);
        return h;
    }

    public String toString() {
        return "GetTheme{identifier=" + this.identifier + ", format=" + this.format + ", theme=" + this.theme + ", documentId=" + this.documentId + "}";
    }

    public static ImmutableGetTheme of(String format, InputTheme theme, long documentId) {
        return new ImmutableGetTheme(format, theme, documentId);
    }

    public static ImmutableGetTheme copyOf(GetTheme instance) {
        if (instance instanceof ImmutableGetTheme) {
            return (ImmutableGetTheme)instance;
        }
        return ImmutableGetTheme.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FORMAT = 1L;
        private static final long INIT_BIT_THEME = 2L;
        private static final long INIT_BIT_DOCUMENT_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String format;
        private InputTheme theme;
        private long documentId;

        private Builder() {
        }

        public final Builder from(GetTheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetTheme instance;
            long bits = 0L;
            if (object instanceof GetTheme) {
                instance = (GetTheme)object;
                this.format(instance.format());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.theme(instance.theme());
                this.documentId(instance.documentId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder format(String format) {
            this.format = Objects.requireNonNull(format, "format");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder theme(InputTheme theme) {
            this.theme = Objects.requireNonNull(theme, "theme");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder documentId(long documentId) {
            this.documentId = documentId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGetTheme build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetTheme(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("format");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("theme");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("documentId");
            }
            return "Cannot build GetTheme, some of required attributes are not set " + attributes;
        }
    }
}

