/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetThemes;

public final class ImmutableGetThemes
implements GetThemes {
    private final int identifier;
    private final String format;
    private final long hash;

    private ImmutableGetThemes(String format, long hash) {
        this.format = Objects.requireNonNull(format, "format");
        this.hash = hash;
        this.identifier = GetThemes.super.identifier();
    }

    private ImmutableGetThemes(Builder builder) {
        this.format = builder.format;
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetThemes.super.identifier();
    }

    private ImmutableGetThemes(int identifier, String format, long hash) {
        this.identifier = identifier;
        this.format = format;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableGetThemes withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetThemes(value, this.format, this.hash);
    }

    public final ImmutableGetThemes withFormat(String value) {
        String newValue = Objects.requireNonNull(value, "format");
        if (this.format.equals(newValue)) {
            return this;
        }
        return new ImmutableGetThemes(this.identifier, newValue, this.hash);
    }

    public final ImmutableGetThemes withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableGetThemes(this.identifier, this.format, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetThemes && this.equalTo(0, (ImmutableGetThemes)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetThemes another) {
        return this.identifier == another.identifier && this.format.equals(another.format) && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.format.hashCode();
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "GetThemes{identifier=" + this.identifier + ", format=" + this.format + ", hash=" + this.hash + "}";
    }

    public static ImmutableGetThemes of(String format, long hash) {
        return new ImmutableGetThemes(format, hash);
    }

    public static ImmutableGetThemes copyOf(GetThemes instance) {
        if (instance instanceof ImmutableGetThemes) {
            return (ImmutableGetThemes)instance;
        }
        return ImmutableGetThemes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FORMAT = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String format;
        private long hash;

        private Builder() {
        }

        public final Builder from(GetThemes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GetThemes instance;
            long bits = 0L;
            if (object instanceof GetThemes) {
                instance = (GetThemes)object;
                this.format(instance.format());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder format(String format) {
            this.format = Objects.requireNonNull(format, "format");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetThemes build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetThemes(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("format");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build GetThemes, some of required attributes are not set " + attributes;
        }
    }
}

