/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputCheckPasswordSRP;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetTmpPassword;

public final class ImmutableGetTmpPassword
implements GetTmpPassword {
    private final int identifier;
    private final InputCheckPasswordSRP password;
    private final int period;

    private ImmutableGetTmpPassword(InputCheckPasswordSRP password, int period) {
        this.password = Objects.requireNonNull(password, "password");
        this.period = period;
        this.identifier = GetTmpPassword.super.identifier();
    }

    private ImmutableGetTmpPassword(Builder builder) {
        this.password = builder.password;
        this.period = builder.period;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetTmpPassword.super.identifier();
    }

    private ImmutableGetTmpPassword(int identifier, InputCheckPasswordSRP password, int period) {
        this.identifier = identifier;
        this.password = password;
        this.period = period;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputCheckPasswordSRP password() {
        return this.password;
    }

    @Override
    public int period() {
        return this.period;
    }

    public final ImmutableGetTmpPassword withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetTmpPassword(value, this.password, this.period);
    }

    public final ImmutableGetTmpPassword withPassword(InputCheckPasswordSRP value) {
        if (this.password == value) {
            return this;
        }
        InputCheckPasswordSRP newValue = Objects.requireNonNull(value, "password");
        return new ImmutableGetTmpPassword(this.identifier, newValue, this.period);
    }

    public final ImmutableGetTmpPassword withPeriod(int value) {
        if (this.period == value) {
            return this;
        }
        return new ImmutableGetTmpPassword(this.identifier, this.password, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetTmpPassword && this.equalTo(0, (ImmutableGetTmpPassword)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetTmpPassword another) {
        return this.identifier == another.identifier && this.password.equals(another.password) && this.period == another.period;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + this.period;
        return h;
    }

    public String toString() {
        return "GetTmpPassword{identifier=" + this.identifier + ", password=" + this.password + ", period=" + this.period + "}";
    }

    public static ImmutableGetTmpPassword of(InputCheckPasswordSRP password, int period) {
        return new ImmutableGetTmpPassword(password, period);
    }

    public static ImmutableGetTmpPassword copyOf(GetTmpPassword instance) {
        if (instance instanceof ImmutableGetTmpPassword) {
            return (ImmutableGetTmpPassword)instance;
        }
        return ImmutableGetTmpPassword.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PASSWORD = 1L;
        private static final long INIT_BIT_PERIOD = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputCheckPasswordSRP password;
        private int period;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetTmpPassword instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetTmpPassword) {
                instance = (GetTmpPassword)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.password(instance.password());
                this.period(instance.period());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder password(InputCheckPasswordSRP password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder period(int period) {
            this.period = period;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGetTmpPassword build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetTmpPassword(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("password");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("period");
            }
            return "Cannot build GetTmpPassword, some of required attributes are not set " + attributes;
        }
    }
}

