/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputWallPaper;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.GetWallPaper;

public final class ImmutableGetWallPaper
implements GetWallPaper {
    private final int identifier;
    private final InputWallPaper wallpaper;

    private ImmutableGetWallPaper(InputWallPaper wallpaper) {
        this.wallpaper = Objects.requireNonNull(wallpaper, "wallpaper");
        this.identifier = GetWallPaper.super.identifier();
    }

    private ImmutableGetWallPaper(Builder builder) {
        this.wallpaper = builder.wallpaper;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GetWallPaper.super.identifier();
    }

    private ImmutableGetWallPaper(int identifier, InputWallPaper wallpaper) {
        this.identifier = identifier;
        this.wallpaper = wallpaper;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputWallPaper wallpaper() {
        return this.wallpaper;
    }

    public final ImmutableGetWallPaper withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGetWallPaper(value, this.wallpaper);
    }

    public final ImmutableGetWallPaper withWallpaper(InputWallPaper value) {
        if (this.wallpaper == value) {
            return this;
        }
        InputWallPaper newValue = Objects.requireNonNull(value, "wallpaper");
        return new ImmutableGetWallPaper(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetWallPaper && this.equalTo(0, (ImmutableGetWallPaper)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetWallPaper another) {
        return this.identifier == another.identifier && this.wallpaper.equals(another.wallpaper);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.wallpaper.hashCode();
        return h;
    }

    public String toString() {
        return "GetWallPaper{identifier=" + this.identifier + ", wallpaper=" + this.wallpaper + "}";
    }

    public static ImmutableGetWallPaper of(InputWallPaper wallpaper) {
        return new ImmutableGetWallPaper(wallpaper);
    }

    public static ImmutableGetWallPaper copyOf(GetWallPaper instance) {
        if (instance instanceof ImmutableGetWallPaper) {
            return (ImmutableGetWallPaper)instance;
        }
        return ImmutableGetWallPaper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_WALLPAPER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputWallPaper wallpaper;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetWallPaper instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GetWallPaper) {
                instance = (GetWallPaper)object;
                this.wallpaper(instance.wallpaper());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder wallpaper(InputWallPaper wallpaper) {
            this.wallpaper = Objects.requireNonNull(wallpaper, "wallpaper");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGetWallPaper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetWallPaper(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("wallpaper");
            }
            return "Cannot build GetWallPaper, some of required attributes are not set " + attributes;
        }
    }
}

