/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.InitTakeoutSession;

public final class ImmutableInitTakeoutSession
implements InitTakeoutSession {
    private final int identifier;
    private final int flags;
    private final boolean contacts;
    private final boolean messageUsers;
    private final boolean messageChats;
    private final boolean messageMegagroups;
    private final boolean messageChannels;
    private final boolean files;
    @Nullable
    private final Long fileMaxSize;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableInitTakeoutSession INSTANCE = ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession());

    private ImmutableInitTakeoutSession() {
        this.fileMaxSize = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.contacts = this.initShim.contacts();
        this.messageUsers = this.initShim.messageUsers();
        this.messageChats = this.initShim.messageChats();
        this.messageMegagroups = this.initShim.messageMegagroups();
        this.messageChannels = this.initShim.messageChannels();
        this.files = this.initShim.files();
        this.initShim = null;
    }

    private ImmutableInitTakeoutSession(Builder builder) {
        this.fileMaxSize = builder.fileMaxSize;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.contactsIsSet()) {
            this.initShim.contacts(builder.contacts);
        }
        if (builder.messageUsersIsSet()) {
            this.initShim.messageUsers(builder.messageUsers);
        }
        if (builder.messageChatsIsSet()) {
            this.initShim.messageChats(builder.messageChats);
        }
        if (builder.messageMegagroupsIsSet()) {
            this.initShim.messageMegagroups(builder.messageMegagroups);
        }
        if (builder.messageChannelsIsSet()) {
            this.initShim.messageChannels(builder.messageChannels);
        }
        if (builder.filesIsSet()) {
            this.initShim.files(builder.files);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.contacts = this.initShim.contacts();
        this.messageUsers = this.initShim.messageUsers();
        this.messageChats = this.initShim.messageChats();
        this.messageMegagroups = this.initShim.messageMegagroups();
        this.messageChannels = this.initShim.messageChannels();
        this.files = this.initShim.files();
        this.initShim = null;
    }

    private ImmutableInitTakeoutSession(int identifier, int flags, boolean contacts, boolean messageUsers, boolean messageChats, boolean messageMegagroups, boolean messageChannels, boolean files, @Nullable Long fileMaxSize) {
        this.identifier = identifier;
        this.flags = flags;
        this.contacts = contacts;
        this.messageUsers = messageUsers;
        this.messageChats = messageChats;
        this.messageMegagroups = messageMegagroups;
        this.messageChannels = messageChannels;
        this.files = files;
        this.fileMaxSize = fileMaxSize;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InitTakeoutSession.super.identifier();
    }

    private int flagsInitialize() {
        return InitTakeoutSession.super.flags();
    }

    private boolean contactsInitialize() {
        return InitTakeoutSession.super.contacts();
    }

    private boolean messageUsersInitialize() {
        return InitTakeoutSession.super.messageUsers();
    }

    private boolean messageChatsInitialize() {
        return InitTakeoutSession.super.messageChats();
    }

    private boolean messageMegagroupsInitialize() {
        return InitTakeoutSession.super.messageMegagroups();
    }

    private boolean messageChannelsInitialize() {
        return InitTakeoutSession.super.messageChannels();
    }

    private boolean filesInitialize() {
        return InitTakeoutSession.super.files();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean contacts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.contacts() : this.contacts;
    }

    @Override
    public boolean messageUsers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.messageUsers() : this.messageUsers;
    }

    @Override
    public boolean messageChats() {
        InitShim shim = this.initShim;
        return shim != null ? shim.messageChats() : this.messageChats;
    }

    @Override
    public boolean messageMegagroups() {
        InitShim shim = this.initShim;
        return shim != null ? shim.messageMegagroups() : this.messageMegagroups;
    }

    @Override
    public boolean messageChannels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.messageChannels() : this.messageChannels;
    }

    @Override
    public boolean files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    @Nullable
    public Long fileMaxSize() {
        return this.fileMaxSize;
    }

    public final ImmutableInitTakeoutSession withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession(value, this.flags, this.contacts, this.messageUsers, this.messageChats, this.messageMegagroups, this.messageChannels, this.files, this.fileMaxSize));
    }

    public final ImmutableInitTakeoutSession withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession(this.identifier, value, this.contacts, this.messageUsers, this.messageChats, this.messageMegagroups, this.messageChannels, this.files, this.fileMaxSize));
    }

    public final ImmutableInitTakeoutSession withContacts(boolean value) {
        if (this.contacts == value) {
            return this;
        }
        return ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession(this.identifier, this.flags, value, this.messageUsers, this.messageChats, this.messageMegagroups, this.messageChannels, this.files, this.fileMaxSize));
    }

    public final ImmutableInitTakeoutSession withMessageUsers(boolean value) {
        if (this.messageUsers == value) {
            return this;
        }
        return ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession(this.identifier, this.flags, this.contacts, value, this.messageChats, this.messageMegagroups, this.messageChannels, this.files, this.fileMaxSize));
    }

    public final ImmutableInitTakeoutSession withMessageChats(boolean value) {
        if (this.messageChats == value) {
            return this;
        }
        return ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession(this.identifier, this.flags, this.contacts, this.messageUsers, value, this.messageMegagroups, this.messageChannels, this.files, this.fileMaxSize));
    }

    public final ImmutableInitTakeoutSession withMessageMegagroups(boolean value) {
        if (this.messageMegagroups == value) {
            return this;
        }
        return ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession(this.identifier, this.flags, this.contacts, this.messageUsers, this.messageChats, value, this.messageChannels, this.files, this.fileMaxSize));
    }

    public final ImmutableInitTakeoutSession withMessageChannels(boolean value) {
        if (this.messageChannels == value) {
            return this;
        }
        return ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession(this.identifier, this.flags, this.contacts, this.messageUsers, this.messageChats, this.messageMegagroups, value, this.files, this.fileMaxSize));
    }

    public final ImmutableInitTakeoutSession withFiles(boolean value) {
        if (this.files == value) {
            return this;
        }
        return ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession(this.identifier, this.flags, this.contacts, this.messageUsers, this.messageChats, this.messageMegagroups, this.messageChannels, value, this.fileMaxSize));
    }

    public final ImmutableInitTakeoutSession withFileMaxSize(@Nullable Long value) {
        if (Objects.equals(this.fileMaxSize, value)) {
            return this;
        }
        return ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession(this.identifier, this.flags, this.contacts, this.messageUsers, this.messageChats, this.messageMegagroups, this.messageChannels, this.files, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInitTakeoutSession && this.equalTo(0, (ImmutableInitTakeoutSession)another);
    }

    private boolean equalTo(int synthetic, ImmutableInitTakeoutSession another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.contacts == another.contacts && this.messageUsers == another.messageUsers && this.messageChats == another.messageChats && this.messageMegagroups == another.messageMegagroups && this.messageChannels == another.messageChannels && this.files == another.files && Objects.equals(this.fileMaxSize, another.fileMaxSize);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.contacts);
        h += (h << 5) + Boolean.hashCode(this.messageUsers);
        h += (h << 5) + Boolean.hashCode(this.messageChats);
        h += (h << 5) + Boolean.hashCode(this.messageMegagroups);
        h += (h << 5) + Boolean.hashCode(this.messageChannels);
        h += (h << 5) + Boolean.hashCode(this.files);
        h += (h << 5) + Objects.hashCode(this.fileMaxSize);
        return h;
    }

    public String toString() {
        return "InitTakeoutSession{identifier=" + this.identifier + ", flags=" + this.flags + ", contacts=" + this.contacts + ", messageUsers=" + this.messageUsers + ", messageChats=" + this.messageChats + ", messageMegagroups=" + this.messageMegagroups + ", messageChannels=" + this.messageChannels + ", files=" + this.files + ", fileMaxSize=" + this.fileMaxSize + "}";
    }

    public static ImmutableInitTakeoutSession of() {
        return INSTANCE;
    }

    private static ImmutableInitTakeoutSession validate(ImmutableInitTakeoutSession instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInitTakeoutSession copyOf(InitTakeoutSession instance) {
        if (instance instanceof ImmutableInitTakeoutSession) {
            return (ImmutableInitTakeoutSession)instance;
        }
        return ImmutableInitTakeoutSession.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CONTACTS = 4L;
        private static final long OPT_BIT_MESSAGE_USERS = 8L;
        private static final long OPT_BIT_MESSAGE_CHATS = 16L;
        private static final long OPT_BIT_MESSAGE_MEGAGROUPS = 32L;
        private static final long OPT_BIT_MESSAGE_CHANNELS = 64L;
        private static final long OPT_BIT_FILES = 128L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean contacts;
        private boolean messageUsers;
        private boolean messageChats;
        private boolean messageMegagroups;
        private boolean messageChannels;
        private boolean files;
        private Long fileMaxSize;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InitTakeoutSession instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InitTakeoutSession) {
                instance = (InitTakeoutSession)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.messageChats(instance.messageChats());
                Long fileMaxSizeValue = instance.fileMaxSize();
                if (fileMaxSizeValue != null) {
                    this.fileMaxSize(fileMaxSizeValue);
                }
                this.flags(instance.flags());
                this.files(instance.files());
                this.messageUsers(instance.messageUsers());
                this.messageMegagroups(instance.messageMegagroups());
                this.contacts(instance.contacts());
                this.messageChannels(instance.messageChannels());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder contacts(boolean contacts) {
            this.contacts = contacts;
            this.optBits |= 4L;
            return this;
        }

        public final Builder messageUsers(boolean messageUsers) {
            this.messageUsers = messageUsers;
            this.optBits |= 8L;
            return this;
        }

        public final Builder messageChats(boolean messageChats) {
            this.messageChats = messageChats;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder messageMegagroups(boolean messageMegagroups) {
            this.messageMegagroups = messageMegagroups;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder messageChannels(boolean messageChannels) {
            this.messageChannels = messageChannels;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder files(boolean files) {
            this.files = files;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder fileMaxSize(@Nullable Long fileMaxSize) {
            this.fileMaxSize = fileMaxSize;
            return this;
        }

        public ImmutableInitTakeoutSession build() {
            return ImmutableInitTakeoutSession.validate(new ImmutableInitTakeoutSession(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean contactsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean messageUsersIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean messageChatsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean messageMegagroupsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean messageChannelsIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean filesIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte contactsBuildStage = 0;
        private boolean contacts;
        private byte messageUsersBuildStage = 0;
        private boolean messageUsers;
        private byte messageChatsBuildStage = 0;
        private boolean messageChats;
        private byte messageMegagroupsBuildStage = 0;
        private boolean messageMegagroups;
        private byte messageChannelsBuildStage = 0;
        private boolean messageChannels;
        private byte filesBuildStage = 0;
        private boolean files;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInitTakeoutSession.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInitTakeoutSession.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean contacts() {
            if (this.contactsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contactsBuildStage == 0) {
                this.contactsBuildStage = (byte)-1;
                this.contacts = ImmutableInitTakeoutSession.this.contactsInitialize();
                this.contactsBuildStage = 1;
            }
            return this.contacts;
        }

        void contacts(boolean contacts) {
            this.contacts = contacts;
            this.contactsBuildStage = 1;
        }

        boolean messageUsers() {
            if (this.messageUsersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.messageUsersBuildStage == 0) {
                this.messageUsersBuildStage = (byte)-1;
                this.messageUsers = ImmutableInitTakeoutSession.this.messageUsersInitialize();
                this.messageUsersBuildStage = 1;
            }
            return this.messageUsers;
        }

        void messageUsers(boolean messageUsers) {
            this.messageUsers = messageUsers;
            this.messageUsersBuildStage = 1;
        }

        boolean messageChats() {
            if (this.messageChatsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.messageChatsBuildStage == 0) {
                this.messageChatsBuildStage = (byte)-1;
                this.messageChats = ImmutableInitTakeoutSession.this.messageChatsInitialize();
                this.messageChatsBuildStage = 1;
            }
            return this.messageChats;
        }

        void messageChats(boolean messageChats) {
            this.messageChats = messageChats;
            this.messageChatsBuildStage = 1;
        }

        boolean messageMegagroups() {
            if (this.messageMegagroupsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.messageMegagroupsBuildStage == 0) {
                this.messageMegagroupsBuildStage = (byte)-1;
                this.messageMegagroups = ImmutableInitTakeoutSession.this.messageMegagroupsInitialize();
                this.messageMegagroupsBuildStage = 1;
            }
            return this.messageMegagroups;
        }

        void messageMegagroups(boolean messageMegagroups) {
            this.messageMegagroups = messageMegagroups;
            this.messageMegagroupsBuildStage = 1;
        }

        boolean messageChannels() {
            if (this.messageChannelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.messageChannelsBuildStage == 0) {
                this.messageChannelsBuildStage = (byte)-1;
                this.messageChannels = ImmutableInitTakeoutSession.this.messageChannelsInitialize();
                this.messageChannelsBuildStage = 1;
            }
            return this.messageChannels;
        }

        void messageChannels(boolean messageChannels) {
            this.messageChannels = messageChannels;
            this.messageChannelsBuildStage = 1;
        }

        boolean files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = ImmutableInitTakeoutSession.this.filesInitialize();
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(boolean files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.contactsBuildStage == -1) {
                attributes.add("contacts");
            }
            if (this.messageUsersBuildStage == -1) {
                attributes.add("messageUsers");
            }
            if (this.messageChatsBuildStage == -1) {
                attributes.add("messageChats");
            }
            if (this.messageMegagroupsBuildStage == -1) {
                attributes.add("messageMegagroups");
            }
            if (this.messageChannelsBuildStage == -1) {
                attributes.add("messageChannels");
            }
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            return "Cannot build InitTakeoutSession, attribute initializers form cycle " + attributes;
        }
    }
}

