/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseTheme;
import telegram4j.tl.InputTheme;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.InstallTheme;

public final class ImmutableInstallTheme
implements InstallTheme {
    private final int identifier;
    private final int flags;
    private final boolean dark;
    @Nullable
    private final InputTheme theme;
    @Nullable
    private final String format;
    @Nullable
    private final BaseTheme baseTheme;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableInstallTheme INSTANCE = ImmutableInstallTheme.validate(new ImmutableInstallTheme());

    private ImmutableInstallTheme() {
        this.theme = null;
        this.format = null;
        this.baseTheme = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.dark = this.initShim.dark();
        this.initShim = null;
    }

    private ImmutableInstallTheme(Builder builder) {
        this.theme = builder.theme;
        this.format = builder.format;
        this.baseTheme = builder.baseTheme;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.darkIsSet()) {
            this.initShim.dark(builder.dark);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.dark = this.initShim.dark();
        this.initShim = null;
    }

    private ImmutableInstallTheme(int identifier, int flags, boolean dark, @Nullable InputTheme theme, @Nullable String format, @Nullable BaseTheme baseTheme) {
        this.identifier = identifier;
        this.flags = flags;
        this.dark = dark;
        this.theme = theme;
        this.format = format;
        this.baseTheme = baseTheme;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InstallTheme.super.identifier();
    }

    private int flagsInitialize() {
        return InstallTheme.super.flags();
    }

    private boolean darkInitialize() {
        return InstallTheme.super.dark();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean dark() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dark() : this.dark;
    }

    @Override
    @Nullable
    public InputTheme theme() {
        return this.theme;
    }

    @Override
    @Nullable
    public String format() {
        return this.format;
    }

    @Override
    @Nullable
    public BaseTheme baseTheme() {
        return this.baseTheme;
    }

    public final ImmutableInstallTheme withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableInstallTheme.validate(new ImmutableInstallTheme(value, this.flags, this.dark, this.theme, this.format, this.baseTheme));
    }

    public final ImmutableInstallTheme withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableInstallTheme.validate(new ImmutableInstallTheme(this.identifier, value, this.dark, this.theme, this.format, this.baseTheme));
    }

    public final ImmutableInstallTheme withDark(boolean value) {
        if (this.dark == value) {
            return this;
        }
        return ImmutableInstallTheme.validate(new ImmutableInstallTheme(this.identifier, this.flags, value, this.theme, this.format, this.baseTheme));
    }

    public final ImmutableInstallTheme withTheme(@Nullable InputTheme value) {
        if (this.theme == value) {
            return this;
        }
        return ImmutableInstallTheme.validate(new ImmutableInstallTheme(this.identifier, this.flags, this.dark, value, this.format, this.baseTheme));
    }

    public final ImmutableInstallTheme withFormat(@Nullable String value) {
        if (Objects.equals(this.format, value)) {
            return this;
        }
        return ImmutableInstallTheme.validate(new ImmutableInstallTheme(this.identifier, this.flags, this.dark, this.theme, value, this.baseTheme));
    }

    public final ImmutableInstallTheme withBaseTheme(@Nullable BaseTheme value) {
        if (this.baseTheme == value) {
            return this;
        }
        return ImmutableInstallTheme.validate(new ImmutableInstallTheme(this.identifier, this.flags, this.dark, this.theme, this.format, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstallTheme && this.equalTo(0, (ImmutableInstallTheme)another);
    }

    private boolean equalTo(int synthetic, ImmutableInstallTheme another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.dark == another.dark && Objects.equals(this.theme, another.theme) && Objects.equals(this.format, another.format) && Objects.equals((Object)this.baseTheme, (Object)another.baseTheme);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.dark);
        h += (h << 5) + Objects.hashCode(this.theme);
        h += (h << 5) + Objects.hashCode(this.format);
        h += (h << 5) + Objects.hashCode((Object)this.baseTheme);
        return h;
    }

    public String toString() {
        return "InstallTheme{identifier=" + this.identifier + ", flags=" + this.flags + ", dark=" + this.dark + ", theme=" + this.theme + ", format=" + this.format + ", baseTheme=" + this.baseTheme + "}";
    }

    public static ImmutableInstallTheme of() {
        return INSTANCE;
    }

    private static ImmutableInstallTheme validate(ImmutableInstallTheme instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableInstallTheme copyOf(InstallTheme instance) {
        if (instance instanceof ImmutableInstallTheme) {
            return (ImmutableInstallTheme)instance;
        }
        return ImmutableInstallTheme.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_DARK = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean dark;
        private InputTheme theme;
        private String format;
        private BaseTheme baseTheme;

        private Builder() {
        }

        public final Builder from(InstallTheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InstallTheme instance;
            long bits = 0L;
            if (object instanceof InstallTheme) {
                BaseTheme baseThemeValue;
                InputTheme themeValue;
                instance = (InstallTheme)object;
                this.flags(instance.flags());
                this.dark(instance.dark());
                String formatValue = instance.format();
                if (formatValue != null) {
                    this.format(formatValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((themeValue = instance.theme()) != null) {
                    this.theme(themeValue);
                }
                if ((baseThemeValue = instance.baseTheme()) != null) {
                    this.baseTheme(baseThemeValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder dark(boolean dark) {
            this.dark = dark;
            this.optBits |= 4L;
            return this;
        }

        public final Builder theme(@Nullable InputTheme theme) {
            this.theme = theme;
            return this;
        }

        public final Builder format(@Nullable String format) {
            this.format = format;
            return this;
        }

        public final Builder baseTheme(@Nullable BaseTheme baseTheme) {
            this.baseTheme = baseTheme;
            return this;
        }

        public ImmutableInstallTheme build() {
            return ImmutableInstallTheme.validate(new ImmutableInstallTheme(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean darkIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte darkBuildStage = 0;
        private boolean dark;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInstallTheme.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInstallTheme.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean dark() {
            if (this.darkBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.darkBuildStage == 0) {
                this.darkBuildStage = (byte)-1;
                this.dark = ImmutableInstallTheme.this.darkInitialize();
                this.darkBuildStage = 1;
            }
            return this.dark;
        }

        void dark(boolean dark) {
            this.dark = dark;
            this.darkBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.darkBuildStage == -1) {
                attributes.add("dark");
            }
            return "Cannot build InstallTheme, attribute initializers form cycle " + attributes;
        }
    }
}

