/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputWallPaper;
import telegram4j.tl.WallPaperSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.InstallWallPaper;

public final class ImmutableInstallWallPaper
implements InstallWallPaper {
    private final int identifier;
    private final InputWallPaper wallpaper;
    private final WallPaperSettings settings;

    private ImmutableInstallWallPaper(InputWallPaper wallpaper, WallPaperSettings settings) {
        this.wallpaper = Objects.requireNonNull(wallpaper, "wallpaper");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = InstallWallPaper.super.identifier();
    }

    private ImmutableInstallWallPaper(Builder builder) {
        this.wallpaper = builder.wallpaper;
        this.settings = builder.settings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InstallWallPaper.super.identifier();
    }

    private ImmutableInstallWallPaper(int identifier, InputWallPaper wallpaper, WallPaperSettings settings) {
        this.identifier = identifier;
        this.wallpaper = wallpaper;
        this.settings = settings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputWallPaper wallpaper() {
        return this.wallpaper;
    }

    @Override
    public WallPaperSettings settings() {
        return this.settings;
    }

    public final ImmutableInstallWallPaper withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInstallWallPaper(value, this.wallpaper, this.settings);
    }

    public final ImmutableInstallWallPaper withWallpaper(InputWallPaper value) {
        if (this.wallpaper == value) {
            return this;
        }
        InputWallPaper newValue = Objects.requireNonNull(value, "wallpaper");
        return new ImmutableInstallWallPaper(this.identifier, newValue, this.settings);
    }

    public final ImmutableInstallWallPaper withSettings(WallPaperSettings value) {
        if (this.settings == value) {
            return this;
        }
        WallPaperSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableInstallWallPaper(this.identifier, this.wallpaper, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstallWallPaper && this.equalTo(0, (ImmutableInstallWallPaper)another);
    }

    private boolean equalTo(int synthetic, ImmutableInstallWallPaper another) {
        return this.identifier == another.identifier && this.wallpaper.equals(another.wallpaper) && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.wallpaper.hashCode();
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "InstallWallPaper{identifier=" + this.identifier + ", wallpaper=" + this.wallpaper + ", settings=" + this.settings + "}";
    }

    public static ImmutableInstallWallPaper of(InputWallPaper wallpaper, WallPaperSettings settings) {
        return new ImmutableInstallWallPaper(wallpaper, settings);
    }

    public static ImmutableInstallWallPaper copyOf(InstallWallPaper instance) {
        if (instance instanceof ImmutableInstallWallPaper) {
            return (ImmutableInstallWallPaper)instance;
        }
        return ImmutableInstallWallPaper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_WALLPAPER = 1L;
        private static final long INIT_BIT_SETTINGS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputWallPaper wallpaper;
        private WallPaperSettings settings;

        private Builder() {
        }

        public final Builder from(InstallWallPaper instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InstallWallPaper instance;
            long bits = 0L;
            if (object instanceof InstallWallPaper) {
                instance = (InstallWallPaper)object;
                this.wallpaper(instance.wallpaper());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder wallpaper(InputWallPaper wallpaper) {
            this.wallpaper = Objects.requireNonNull(wallpaper, "wallpaper");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder settings(WallPaperSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInstallWallPaper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInstallWallPaper(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("wallpaper");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build InstallWallPaper, some of required attributes are not set " + attributes;
        }
    }
}

