/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.RegisterDevice;

public final class ImmutableRegisterDevice
implements RegisterDevice {
    private final int identifier;
    private final int flags;
    private final boolean noMuted;
    private final int tokenType;
    private final String token;
    private final boolean appSandbox;
    private final ByteBuf secret;
    private final List<Long> otherUids;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRegisterDevice(int tokenType, String token, boolean appSandbox) {
        this.tokenType = tokenType;
        this.token = Objects.requireNonNull(token, "token");
        this.appSandbox = appSandbox;
        this.secret = null;
        this.otherUids = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noMuted = this.initShim.noMuted();
        this.initShim = null;
    }

    private ImmutableRegisterDevice(Builder builder) {
        this.tokenType = builder.tokenType;
        this.token = builder.token;
        this.appSandbox = builder.appSandbox;
        this.secret = builder.secret_build();
        this.otherUids = ImmutableRegisterDevice.createUnmodifiableList(true, builder.otherUids);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.noMutedIsSet()) {
            this.initShim.noMuted(builder.noMuted);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.noMuted = this.initShim.noMuted();
        this.initShim = null;
    }

    private ImmutableRegisterDevice(int identifier, int flags, boolean noMuted, int tokenType, String token, boolean appSandbox, ByteBuf secret, List<Long> otherUids) {
        this.identifier = identifier;
        this.flags = flags;
        this.noMuted = noMuted;
        this.tokenType = tokenType;
        this.token = token;
        this.appSandbox = appSandbox;
        this.secret = secret;
        this.otherUids = otherUids;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return RegisterDevice.super.identifier();
    }

    private int flagsInitialize() {
        return RegisterDevice.super.flags();
    }

    private boolean noMutedInitialize() {
        return RegisterDevice.super.noMuted();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean noMuted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noMuted() : this.noMuted;
    }

    @Override
    public int tokenType() {
        return this.tokenType;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public boolean appSandbox() {
        return this.appSandbox;
    }

    @Override
    public ByteBuf secret() {
        return this.secret.duplicate();
    }

    @Override
    public List<Long> otherUids() {
        return this.otherUids;
    }

    public final ImmutableRegisterDevice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRegisterDevice(value, this.flags, this.noMuted, this.tokenType, this.token, this.appSandbox, this.secret, this.otherUids);
    }

    public final ImmutableRegisterDevice withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableRegisterDevice(this.identifier, value, this.noMuted, this.tokenType, this.token, this.appSandbox, this.secret, this.otherUids);
    }

    public final ImmutableRegisterDevice withNoMuted(boolean value) {
        if (this.noMuted == value) {
            return this;
        }
        return new ImmutableRegisterDevice(this.identifier, this.flags, value, this.tokenType, this.token, this.appSandbox, this.secret, this.otherUids);
    }

    public final ImmutableRegisterDevice withTokenType(int value) {
        if (this.tokenType == value) {
            return this;
        }
        return new ImmutableRegisterDevice(this.identifier, this.flags, this.noMuted, value, this.token, this.appSandbox, this.secret, this.otherUids);
    }

    public final ImmutableRegisterDevice withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ImmutableRegisterDevice(this.identifier, this.flags, this.noMuted, this.tokenType, newValue, this.appSandbox, this.secret, this.otherUids);
    }

    public final ImmutableRegisterDevice withAppSandbox(boolean value) {
        if (this.appSandbox == value) {
            return this;
        }
        return new ImmutableRegisterDevice(this.identifier, this.flags, this.noMuted, this.tokenType, this.token, value, this.secret, this.otherUids);
    }

    public ImmutableRegisterDevice withSecret(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.secret == newValue) {
            return this;
        }
        return new ImmutableRegisterDevice(this.identifier, this.flags, this.noMuted, this.tokenType, this.token, this.appSandbox, newValue, this.otherUids);
    }

    public final ImmutableRegisterDevice withOtherUids(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableRegisterDevice.createUnmodifiableList(false, wrappedList);
        return new ImmutableRegisterDevice(this.identifier, this.flags, this.noMuted, this.tokenType, this.token, this.appSandbox, this.secret, newValue);
    }

    public final ImmutableRegisterDevice withOtherUids(Iterable<Long> elements) {
        if (this.otherUids == elements) {
            return this;
        }
        List<Long> newValue = ImmutableRegisterDevice.createUnmodifiableList(false, ImmutableRegisterDevice.createSafeList(elements, true, false));
        return new ImmutableRegisterDevice(this.identifier, this.flags, this.noMuted, this.tokenType, this.token, this.appSandbox, this.secret, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRegisterDevice && this.equalTo(0, (ImmutableRegisterDevice)another);
    }

    private boolean equalTo(int synthetic, ImmutableRegisterDevice another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.noMuted == another.noMuted && this.tokenType == another.tokenType && this.token.equals(another.token) && this.appSandbox == another.appSandbox && this.secret().equals((Object)another.secret()) && this.otherUids.equals(another.otherUids);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.noMuted);
        h += (h << 5) + this.tokenType;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + Boolean.hashCode(this.appSandbox);
        h += (h << 5) + this.secret().hashCode();
        h += (h << 5) + this.otherUids.hashCode();
        return h;
    }

    public String toString() {
        return "RegisterDevice{identifier=" + this.identifier + ", flags=" + this.flags + ", noMuted=" + this.noMuted + ", tokenType=" + this.tokenType + ", token=" + this.token + ", appSandbox=" + this.appSandbox + ", secret=" + ByteBufUtil.hexDump((ByteBuf)this.secret) + ", otherUids=" + this.otherUids + "}";
    }

    public static ImmutableRegisterDevice of(int tokenType, String token, boolean appSandbox) {
        return new ImmutableRegisterDevice(tokenType, token, appSandbox);
    }

    public static ImmutableRegisterDevice copyOf(RegisterDevice instance) {
        if (instance instanceof ImmutableRegisterDevice) {
            return (ImmutableRegisterDevice)instance;
        }
        return ImmutableRegisterDevice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TOKEN_TYPE = 1L;
        private static final long INIT_BIT_TOKEN = 2L;
        private static final long INIT_BIT_APP_SANDBOX = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_NO_MUTED = 4L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf secret_value = null;
        private int identifier;
        private int flags;
        private boolean noMuted;
        private int tokenType;
        private String token;
        private boolean appSandbox;
        private List<Long> otherUids = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(RegisterDevice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RegisterDevice instance;
            long bits = 0L;
            if (object instanceof RegisterDevice) {
                instance = (RegisterDevice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.noMuted(instance.noMuted());
                this.appSandbox(instance.appSandbox());
                this.addAllOtherUids(instance.otherUids());
                this.flags(instance.flags());
                this.secret(instance.secret());
                this.tokenType(instance.tokenType());
                this.token(instance.token());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder noMuted(boolean noMuted) {
            this.noMuted = noMuted;
            this.optBits |= 4L;
            return this;
        }

        public final Builder tokenType(int tokenType) {
            this.tokenType = tokenType;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder appSandbox(boolean appSandbox) {
            this.appSandbox = appSandbox;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder secret(ByteBuf value) {
            this.secret_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder addOtherUid(long element) {
            this.otherUids.add(element);
            return this;
        }

        public final Builder addOtherUids(long ... elements) {
            for (long element : elements) {
                this.otherUids.add(element);
            }
            return this;
        }

        public final Builder otherUids(Iterable<Long> elements) {
            this.otherUids.clear();
            return this.addAllOtherUids(elements);
        }

        public final Builder addAllOtherUids(Iterable<Long> elements) {
            for (Long element : elements) {
                this.otherUids.add(Objects.requireNonNull(element, "otherUids element"));
            }
            return this;
        }

        public ImmutableRegisterDevice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRegisterDevice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean noMutedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tokenType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("appSandbox");
            }
            return "Cannot build RegisterDevice, some of required attributes are not set " + attributes;
        }

        private ByteBuf secret_build() {
            return Objects.requireNonNull(this.secret_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte noMutedBuildStage = 0;
        private boolean noMuted;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableRegisterDevice.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableRegisterDevice.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean noMuted() {
            if (this.noMutedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noMutedBuildStage == 0) {
                this.noMutedBuildStage = (byte)-1;
                this.noMuted = ImmutableRegisterDevice.this.noMutedInitialize();
                this.noMutedBuildStage = 1;
            }
            return this.noMuted;
        }

        void noMuted(boolean noMuted) {
            this.noMuted = noMuted;
            this.noMutedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.noMutedBuildStage == -1) {
                attributes.add("noMuted");
            }
            return "Cannot build RegisterDevice, attribute initializers form cycle " + attributes;
        }
    }
}

