/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.ReportReason;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.ReportPeer;

public final class ImmutableReportPeer
implements ReportPeer {
    private final int identifier;
    private final InputPeer peer;
    private final ReportReason reason;
    private final String message;

    private ImmutableReportPeer(InputPeer peer, ReportReason reason, String message) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.reason = Objects.requireNonNull(reason, "reason");
        this.message = Objects.requireNonNull(message, "message");
        this.identifier = ReportPeer.super.identifier();
    }

    private ImmutableReportPeer(Builder builder) {
        this.peer = builder.peer;
        this.reason = builder.reason;
        this.message = builder.message;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReportPeer.super.identifier();
    }

    private ImmutableReportPeer(int identifier, InputPeer peer, ReportReason reason, String message) {
        this.identifier = identifier;
        this.peer = peer;
        this.reason = reason;
        this.message = message;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public ReportReason reason() {
        return this.reason;
    }

    @Override
    public String message() {
        return this.message;
    }

    public final ImmutableReportPeer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReportPeer(value, this.peer, this.reason, this.message);
    }

    public final ImmutableReportPeer withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableReportPeer(this.identifier, newValue, this.reason, this.message);
    }

    public final ImmutableReportPeer withReason(ReportReason value) {
        ReportReason newValue = Objects.requireNonNull(value, "reason");
        if (this.reason == newValue) {
            return this;
        }
        return new ImmutableReportPeer(this.identifier, this.peer, newValue, this.message);
    }

    public final ImmutableReportPeer withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableReportPeer(this.identifier, this.peer, this.reason, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReportPeer && this.equalTo(0, (ImmutableReportPeer)another);
    }

    private boolean equalTo(int synthetic, ImmutableReportPeer another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.reason.equals((Object)another.reason) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.reason.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "ReportPeer{identifier=" + this.identifier + ", peer=" + this.peer + ", reason=" + this.reason + ", message=" + this.message + "}";
    }

    public static ImmutableReportPeer of(InputPeer peer, ReportReason reason, String message) {
        return new ImmutableReportPeer(peer, reason, message);
    }

    public static ImmutableReportPeer copyOf(ReportPeer instance) {
        if (instance instanceof ImmutableReportPeer) {
            return (ImmutableReportPeer)instance;
        }
        return ImmutableReportPeer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_REASON = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private ReportReason reason;
        private String message;

        private Builder() {
        }

        public final Builder from(ReportPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReportPeer instance;
            long bits = 0L;
            if (object instanceof ReportPeer) {
                instance = (ReportPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reason(instance.reason());
                this.message(instance.message());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder reason(ReportReason reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableReportPeer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReportPeer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reason");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build ReportPeer, some of required attributes are not set " + attributes;
        }
    }
}

