/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputPhoto;
import telegram4j.tl.ReportReason;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.ReportProfilePhoto;

public final class ImmutableReportProfilePhoto
implements ReportProfilePhoto {
    private final int identifier;
    private final InputPeer peer;
    private final InputPhoto photoId;
    private final ReportReason reason;
    private final String message;

    private ImmutableReportProfilePhoto(InputPeer peer, InputPhoto photoId, ReportReason reason, String message) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.photoId = Objects.requireNonNull(photoId, "photoId");
        this.reason = Objects.requireNonNull(reason, "reason");
        this.message = Objects.requireNonNull(message, "message");
        this.identifier = ReportProfilePhoto.super.identifier();
    }

    private ImmutableReportProfilePhoto(Builder builder) {
        this.peer = builder.peer;
        this.photoId = builder.photoId;
        this.reason = builder.reason;
        this.message = builder.message;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ReportProfilePhoto.super.identifier();
    }

    private ImmutableReportProfilePhoto(int identifier, InputPeer peer, InputPhoto photoId, ReportReason reason, String message) {
        this.identifier = identifier;
        this.peer = peer;
        this.photoId = photoId;
        this.reason = reason;
        this.message = message;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public InputPhoto photoId() {
        return this.photoId;
    }

    @Override
    public ReportReason reason() {
        return this.reason;
    }

    @Override
    public String message() {
        return this.message;
    }

    public final ImmutableReportProfilePhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableReportProfilePhoto(value, this.peer, this.photoId, this.reason, this.message);
    }

    public final ImmutableReportProfilePhoto withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableReportProfilePhoto(this.identifier, newValue, this.photoId, this.reason, this.message);
    }

    public final ImmutableReportProfilePhoto withPhotoId(InputPhoto value) {
        if (this.photoId == value) {
            return this;
        }
        InputPhoto newValue = Objects.requireNonNull(value, "photoId");
        return new ImmutableReportProfilePhoto(this.identifier, this.peer, newValue, this.reason, this.message);
    }

    public final ImmutableReportProfilePhoto withReason(ReportReason value) {
        ReportReason newValue = Objects.requireNonNull(value, "reason");
        if (this.reason == newValue) {
            return this;
        }
        return new ImmutableReportProfilePhoto(this.identifier, this.peer, this.photoId, newValue, this.message);
    }

    public final ImmutableReportProfilePhoto withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableReportProfilePhoto(this.identifier, this.peer, this.photoId, this.reason, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReportProfilePhoto && this.equalTo(0, (ImmutableReportProfilePhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableReportProfilePhoto another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.photoId.equals(another.photoId) && this.reason.equals((Object)another.reason) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.photoId.hashCode();
        h += (h << 5) + this.reason.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "ReportProfilePhoto{identifier=" + this.identifier + ", peer=" + this.peer + ", photoId=" + this.photoId + ", reason=" + this.reason + ", message=" + this.message + "}";
    }

    public static ImmutableReportProfilePhoto of(InputPeer peer, InputPhoto photoId, ReportReason reason, String message) {
        return new ImmutableReportProfilePhoto(peer, photoId, reason, message);
    }

    public static ImmutableReportProfilePhoto copyOf(ReportProfilePhoto instance) {
        if (instance instanceof ImmutableReportProfilePhoto) {
            return (ImmutableReportProfilePhoto)instance;
        }
        return ImmutableReportProfilePhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_PHOTO_ID = 2L;
        private static final long INIT_BIT_REASON = 4L;
        private static final long INIT_BIT_MESSAGE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private InputPhoto photoId;
        private ReportReason reason;
        private String message;

        private Builder() {
        }

        public final Builder from(ReportProfilePhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReportProfilePhoto instance;
            long bits = 0L;
            if (object instanceof ReportProfilePhoto) {
                instance = (ReportProfilePhoto)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reason(instance.reason());
                this.photoId(instance.photoId());
                this.message(instance.message());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder photoId(InputPhoto photoId) {
            this.photoId = Objects.requireNonNull(photoId, "photoId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder reason(ReportReason reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableReportProfilePhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReportProfilePhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("photoId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("reason");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build ReportProfilePhoto, some of required attributes are not set " + attributes;
        }
    }
}

