/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.ResetAuthorization;

public final class ImmutableResetAuthorization
implements ResetAuthorization {
    private final int identifier;
    private final long hash;

    private ImmutableResetAuthorization(long hash) {
        this.hash = hash;
        this.identifier = ResetAuthorization.super.identifier();
    }

    private ImmutableResetAuthorization(Builder builder) {
        this.hash = builder.hash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ResetAuthorization.super.identifier();
    }

    private ImmutableResetAuthorization(int identifier, long hash) {
        this.identifier = identifier;
        this.hash = hash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    public final ImmutableResetAuthorization withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableResetAuthorization(value, this.hash);
    }

    public final ImmutableResetAuthorization withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableResetAuthorization(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResetAuthorization && this.equalTo(0, (ImmutableResetAuthorization)another);
    }

    private boolean equalTo(int synthetic, ImmutableResetAuthorization another) {
        return this.identifier == another.identifier && this.hash == another.hash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "ResetAuthorization{identifier=" + this.identifier + ", hash=" + this.hash + "}";
    }

    public static ImmutableResetAuthorization of(long hash) {
        return new ImmutableResetAuthorization(hash);
    }

    public static ImmutableResetAuthorization copyOf(ResetAuthorization instance) {
        if (instance instanceof ImmutableResetAuthorization) {
            return (ImmutableResetAuthorization)instance;
        }
        return ImmutableResetAuthorization.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ResetAuthorization instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ResetAuthorization) {
                instance = (ResetAuthorization)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableResetAuthorization build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResetAuthorization(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build ResetAuthorization, some of required attributes are not set " + attributes;
        }
    }
}

