/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.ResetNotifySettings;

public final class ImmutableResetNotifySettings
implements ResetNotifySettings {
    private final int identifier;
    private static final ImmutableResetNotifySettings INSTANCE = ImmutableResetNotifySettings.validate(new ImmutableResetNotifySettings());

    private ImmutableResetNotifySettings() {
        this.identifier = ResetNotifySettings.super.identifier();
    }

    private ImmutableResetNotifySettings(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : ResetNotifySettings.super.identifier();
    }

    private ImmutableResetNotifySettings(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableResetNotifySettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableResetNotifySettings.validate(new ImmutableResetNotifySettings(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResetNotifySettings && this.equalTo(0, (ImmutableResetNotifySettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableResetNotifySettings another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "ResetNotifySettings{identifier=" + this.identifier + "}";
    }

    public static ImmutableResetNotifySettings of() {
        return INSTANCE;
    }

    private static ImmutableResetNotifySettings validate(ImmutableResetNotifySettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableResetNotifySettings copyOf(ResetNotifySettings instance) {
        if (instance instanceof ImmutableResetNotifySettings) {
            return (ImmutableResetNotifySettings)instance;
        }
        return ImmutableResetNotifySettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(ResetNotifySettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ResetNotifySettings instance;
            long bits = 0L;
            if (object instanceof ResetNotifySettings) {
                instance = (ResetNotifySettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableResetNotifySettings build() {
            return ImmutableResetNotifySettings.validate(new ImmutableResetNotifySettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

