/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.AutoDownloadSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SaveAutoDownloadSettings;

public final class ImmutableSaveAutoDownloadSettings
implements SaveAutoDownloadSettings {
    private final int identifier;
    private final int flags;
    private final boolean low;
    private final boolean high;
    private final AutoDownloadSettings settings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSaveAutoDownloadSettings(AutoDownloadSettings settings) {
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.low = this.initShim.low();
        this.high = this.initShim.high();
        this.initShim = null;
    }

    private ImmutableSaveAutoDownloadSettings(Builder builder) {
        this.settings = builder.settings;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.lowIsSet()) {
            this.initShim.low(builder.low);
        }
        if (builder.highIsSet()) {
            this.initShim.high(builder.high);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.low = this.initShim.low();
        this.high = this.initShim.high();
        this.initShim = null;
    }

    private ImmutableSaveAutoDownloadSettings(int identifier, int flags, boolean low, boolean high, AutoDownloadSettings settings) {
        this.identifier = identifier;
        this.flags = flags;
        this.low = low;
        this.high = high;
        this.settings = settings;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SaveAutoDownloadSettings.super.identifier();
    }

    private int flagsInitialize() {
        return SaveAutoDownloadSettings.super.flags();
    }

    private boolean lowInitialize() {
        return SaveAutoDownloadSettings.super.low();
    }

    private boolean highInitialize() {
        return SaveAutoDownloadSettings.super.high();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean low() {
        InitShim shim = this.initShim;
        return shim != null ? shim.low() : this.low;
    }

    @Override
    public boolean high() {
        InitShim shim = this.initShim;
        return shim != null ? shim.high() : this.high;
    }

    @Override
    public AutoDownloadSettings settings() {
        return this.settings;
    }

    public final ImmutableSaveAutoDownloadSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveAutoDownloadSettings(value, this.flags, this.low, this.high, this.settings);
    }

    public final ImmutableSaveAutoDownloadSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSaveAutoDownloadSettings(this.identifier, value, this.low, this.high, this.settings);
    }

    public final ImmutableSaveAutoDownloadSettings withLow(boolean value) {
        if (this.low == value) {
            return this;
        }
        return new ImmutableSaveAutoDownloadSettings(this.identifier, this.flags, value, this.high, this.settings);
    }

    public final ImmutableSaveAutoDownloadSettings withHigh(boolean value) {
        if (this.high == value) {
            return this;
        }
        return new ImmutableSaveAutoDownloadSettings(this.identifier, this.flags, this.low, value, this.settings);
    }

    public final ImmutableSaveAutoDownloadSettings withSettings(AutoDownloadSettings value) {
        if (this.settings == value) {
            return this;
        }
        AutoDownloadSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableSaveAutoDownloadSettings(this.identifier, this.flags, this.low, this.high, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveAutoDownloadSettings && this.equalTo(0, (ImmutableSaveAutoDownloadSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveAutoDownloadSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.low == another.low && this.high == another.high && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.low);
        h += (h << 5) + Boolean.hashCode(this.high);
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "SaveAutoDownloadSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", low=" + this.low + ", high=" + this.high + ", settings=" + this.settings + "}";
    }

    public static ImmutableSaveAutoDownloadSettings of(AutoDownloadSettings settings) {
        return new ImmutableSaveAutoDownloadSettings(settings);
    }

    public static ImmutableSaveAutoDownloadSettings copyOf(SaveAutoDownloadSettings instance) {
        if (instance instanceof ImmutableSaveAutoDownloadSettings) {
            return (ImmutableSaveAutoDownloadSettings)instance;
        }
        return ImmutableSaveAutoDownloadSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SETTINGS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_LOW = 4L;
        private static final long OPT_BIT_HIGH = 8L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean low;
        private boolean high;
        private AutoDownloadSettings settings;

        private Builder() {
        }

        public final Builder from(SaveAutoDownloadSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SaveAutoDownloadSettings instance;
            long bits = 0L;
            if (object instanceof SaveAutoDownloadSettings) {
                instance = (SaveAutoDownloadSettings)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.high(instance.high());
                this.low(instance.low());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder low(boolean low) {
            this.low = low;
            this.optBits |= 4L;
            return this;
        }

        public final Builder high(boolean high) {
            this.high = high;
            this.optBits |= 8L;
            return this;
        }

        public final Builder settings(AutoDownloadSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSaveAutoDownloadSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveAutoDownloadSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean lowIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean highIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build SaveAutoDownloadSettings, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte lowBuildStage = 0;
        private boolean low;
        private byte highBuildStage = 0;
        private boolean high;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSaveAutoDownloadSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSaveAutoDownloadSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean low() {
            if (this.lowBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lowBuildStage == 0) {
                this.lowBuildStage = (byte)-1;
                this.low = ImmutableSaveAutoDownloadSettings.this.lowInitialize();
                this.lowBuildStage = 1;
            }
            return this.low;
        }

        void low(boolean low) {
            this.low = low;
            this.lowBuildStage = 1;
        }

        boolean high() {
            if (this.highBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.highBuildStage == 0) {
                this.highBuildStage = (byte)-1;
                this.high = ImmutableSaveAutoDownloadSettings.this.highInitialize();
                this.highBuildStage = 1;
            }
            return this.high;
        }

        void high(boolean high) {
            this.high = high;
            this.highBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.lowBuildStage == -1) {
                attributes.add("low");
            }
            if (this.highBuildStage == -1) {
                attributes.add("high");
            }
            return "Cannot build SaveAutoDownloadSettings, attribute initializers form cycle " + attributes;
        }
    }
}

