/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputDocument;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SaveRingtone;

public final class ImmutableSaveRingtone
implements SaveRingtone {
    private final int identifier;
    private final InputDocument id;
    private final boolean unsave;

    private ImmutableSaveRingtone(InputDocument id, boolean unsave) {
        this.id = Objects.requireNonNull(id, "id");
        this.unsave = unsave;
        this.identifier = SaveRingtone.super.identifier();
    }

    private ImmutableSaveRingtone(Builder builder) {
        this.id = builder.id;
        this.unsave = builder.unsave;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SaveRingtone.super.identifier();
    }

    private ImmutableSaveRingtone(int identifier, InputDocument id, boolean unsave) {
        this.identifier = identifier;
        this.id = id;
        this.unsave = unsave;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputDocument id() {
        return this.id;
    }

    @Override
    public boolean unsave() {
        return this.unsave;
    }

    public final ImmutableSaveRingtone withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveRingtone(value, this.id, this.unsave);
    }

    public final ImmutableSaveRingtone withId(InputDocument value) {
        if (this.id == value) {
            return this;
        }
        InputDocument newValue = Objects.requireNonNull(value, "id");
        return new ImmutableSaveRingtone(this.identifier, newValue, this.unsave);
    }

    public final ImmutableSaveRingtone withUnsave(boolean value) {
        if (this.unsave == value) {
            return this;
        }
        return new ImmutableSaveRingtone(this.identifier, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveRingtone && this.equalTo(0, (ImmutableSaveRingtone)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveRingtone another) {
        return this.identifier == another.identifier && this.id.equals(another.id) && this.unsave == another.unsave;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Boolean.hashCode(this.unsave);
        return h;
    }

    public String toString() {
        return "SaveRingtone{identifier=" + this.identifier + ", id=" + this.id + ", unsave=" + this.unsave + "}";
    }

    public static ImmutableSaveRingtone of(InputDocument id, boolean unsave) {
        return new ImmutableSaveRingtone(id, unsave);
    }

    public static ImmutableSaveRingtone copyOf(SaveRingtone instance) {
        if (instance instanceof ImmutableSaveRingtone) {
            return (ImmutableSaveRingtone)instance;
        }
        return ImmutableSaveRingtone.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_UNSAVE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputDocument id;
        private boolean unsave;

        private Builder() {
        }

        public final Builder from(SaveRingtone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SaveRingtone instance;
            long bits = 0L;
            if (object instanceof SaveRingtone) {
                instance = (SaveRingtone)object;
                this.unsave(instance.unsave());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(InputDocument id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder unsave(boolean unsave) {
            this.unsave = unsave;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSaveRingtone build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveRingtone(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("unsave");
            }
            return "Cannot build SaveRingtone, some of required attributes are not set " + attributes;
        }
    }
}

