/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputSecureValue;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SaveSecureValue;

public final class ImmutableSaveSecureValue
implements SaveSecureValue {
    private final int identifier;
    private final InputSecureValue value;
    private final long secureSecretId;

    private ImmutableSaveSecureValue(InputSecureValue value, long secureSecretId) {
        this.value = Objects.requireNonNull(value, "value");
        this.secureSecretId = secureSecretId;
        this.identifier = SaveSecureValue.super.identifier();
    }

    private ImmutableSaveSecureValue(Builder builder) {
        this.value = builder.value;
        this.secureSecretId = builder.secureSecretId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SaveSecureValue.super.identifier();
    }

    private ImmutableSaveSecureValue(int identifier, InputSecureValue value, long secureSecretId) {
        this.identifier = identifier;
        this.value = value;
        this.secureSecretId = secureSecretId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputSecureValue value() {
        return this.value;
    }

    @Override
    public long secureSecretId() {
        return this.secureSecretId;
    }

    public final ImmutableSaveSecureValue withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveSecureValue(value, this.value, this.secureSecretId);
    }

    public final ImmutableSaveSecureValue withValue(InputSecureValue value) {
        if (this.value == value) {
            return this;
        }
        InputSecureValue newValue = Objects.requireNonNull(value, "value");
        return new ImmutableSaveSecureValue(this.identifier, newValue, this.secureSecretId);
    }

    public final ImmutableSaveSecureValue withSecureSecretId(long value) {
        if (this.secureSecretId == value) {
            return this;
        }
        return new ImmutableSaveSecureValue(this.identifier, this.value, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveSecureValue && this.equalTo(0, (ImmutableSaveSecureValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveSecureValue another) {
        return this.identifier == another.identifier && this.value.equals(another.value) && this.secureSecretId == another.secureSecretId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Long.hashCode(this.secureSecretId);
        return h;
    }

    public String toString() {
        return "SaveSecureValue{identifier=" + this.identifier + ", value=" + this.value + ", secureSecretId=" + this.secureSecretId + "}";
    }

    public static ImmutableSaveSecureValue of(InputSecureValue value, long secureSecretId) {
        return new ImmutableSaveSecureValue(value, secureSecretId);
    }

    public static ImmutableSaveSecureValue copyOf(SaveSecureValue instance) {
        if (instance instanceof ImmutableSaveSecureValue) {
            return (ImmutableSaveSecureValue)instance;
        }
        return ImmutableSaveSecureValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_SECURE_SECRET_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputSecureValue value;
        private long secureSecretId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SaveSecureValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SaveSecureValue) {
                instance = (SaveSecureValue)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.value(instance.value());
                this.secureSecretId(instance.secureSecretId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder value(InputSecureValue value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder secureSecretId(long secureSecretId) {
            this.secureSecretId = secureSecretId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSaveSecureValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveSecureValue(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("secureSecretId");
            }
            return "Cannot build SaveSecureValue, some of required attributes are not set " + attributes;
        }
    }
}

