/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputTheme;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SaveTheme;

public final class ImmutableSaveTheme
implements SaveTheme {
    private final int identifier;
    private final InputTheme theme;
    private final boolean unsave;

    private ImmutableSaveTheme(InputTheme theme, boolean unsave) {
        this.theme = Objects.requireNonNull(theme, "theme");
        this.unsave = unsave;
        this.identifier = SaveTheme.super.identifier();
    }

    private ImmutableSaveTheme(Builder builder) {
        this.theme = builder.theme;
        this.unsave = builder.unsave;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SaveTheme.super.identifier();
    }

    private ImmutableSaveTheme(int identifier, InputTheme theme, boolean unsave) {
        this.identifier = identifier;
        this.theme = theme;
        this.unsave = unsave;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputTheme theme() {
        return this.theme;
    }

    @Override
    public boolean unsave() {
        return this.unsave;
    }

    public final ImmutableSaveTheme withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveTheme(value, this.theme, this.unsave);
    }

    public final ImmutableSaveTheme withTheme(InputTheme value) {
        if (this.theme == value) {
            return this;
        }
        InputTheme newValue = Objects.requireNonNull(value, "theme");
        return new ImmutableSaveTheme(this.identifier, newValue, this.unsave);
    }

    public final ImmutableSaveTheme withUnsave(boolean value) {
        if (this.unsave == value) {
            return this;
        }
        return new ImmutableSaveTheme(this.identifier, this.theme, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveTheme && this.equalTo(0, (ImmutableSaveTheme)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveTheme another) {
        return this.identifier == another.identifier && this.theme.equals(another.theme) && this.unsave == another.unsave;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.theme.hashCode();
        h += (h << 5) + Boolean.hashCode(this.unsave);
        return h;
    }

    public String toString() {
        return "SaveTheme{identifier=" + this.identifier + ", theme=" + this.theme + ", unsave=" + this.unsave + "}";
    }

    public static ImmutableSaveTheme of(InputTheme theme, boolean unsave) {
        return new ImmutableSaveTheme(theme, unsave);
    }

    public static ImmutableSaveTheme copyOf(SaveTheme instance) {
        if (instance instanceof ImmutableSaveTheme) {
            return (ImmutableSaveTheme)instance;
        }
        return ImmutableSaveTheme.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_THEME = 1L;
        private static final long INIT_BIT_UNSAVE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputTheme theme;
        private boolean unsave;

        private Builder() {
        }

        public final Builder from(SaveTheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SaveTheme instance;
            long bits = 0L;
            if (object instanceof SaveTheme) {
                instance = (SaveTheme)object;
                this.unsave(instance.unsave());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.theme(instance.theme());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder theme(InputTheme theme) {
            this.theme = Objects.requireNonNull(theme, "theme");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder unsave(boolean unsave) {
            this.unsave = unsave;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSaveTheme build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveTheme(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("theme");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("unsave");
            }
            return "Cannot build SaveTheme, some of required attributes are not set " + attributes;
        }
    }
}

