/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputWallPaper;
import telegram4j.tl.WallPaperSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SaveWallPaper;

public final class ImmutableSaveWallPaper
implements SaveWallPaper {
    private final int identifier;
    private final InputWallPaper wallpaper;
    private final boolean unsave;
    private final WallPaperSettings settings;

    private ImmutableSaveWallPaper(InputWallPaper wallpaper, boolean unsave, WallPaperSettings settings) {
        this.wallpaper = Objects.requireNonNull(wallpaper, "wallpaper");
        this.unsave = unsave;
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = SaveWallPaper.super.identifier();
    }

    private ImmutableSaveWallPaper(Builder builder) {
        this.wallpaper = builder.wallpaper;
        this.unsave = builder.unsave;
        this.settings = builder.settings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SaveWallPaper.super.identifier();
    }

    private ImmutableSaveWallPaper(int identifier, InputWallPaper wallpaper, boolean unsave, WallPaperSettings settings) {
        this.identifier = identifier;
        this.wallpaper = wallpaper;
        this.unsave = unsave;
        this.settings = settings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputWallPaper wallpaper() {
        return this.wallpaper;
    }

    @Override
    public boolean unsave() {
        return this.unsave;
    }

    @Override
    public WallPaperSettings settings() {
        return this.settings;
    }

    public final ImmutableSaveWallPaper withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSaveWallPaper(value, this.wallpaper, this.unsave, this.settings);
    }

    public final ImmutableSaveWallPaper withWallpaper(InputWallPaper value) {
        if (this.wallpaper == value) {
            return this;
        }
        InputWallPaper newValue = Objects.requireNonNull(value, "wallpaper");
        return new ImmutableSaveWallPaper(this.identifier, newValue, this.unsave, this.settings);
    }

    public final ImmutableSaveWallPaper withUnsave(boolean value) {
        if (this.unsave == value) {
            return this;
        }
        return new ImmutableSaveWallPaper(this.identifier, this.wallpaper, value, this.settings);
    }

    public final ImmutableSaveWallPaper withSettings(WallPaperSettings value) {
        if (this.settings == value) {
            return this;
        }
        WallPaperSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableSaveWallPaper(this.identifier, this.wallpaper, this.unsave, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSaveWallPaper && this.equalTo(0, (ImmutableSaveWallPaper)another);
    }

    private boolean equalTo(int synthetic, ImmutableSaveWallPaper another) {
        return this.identifier == another.identifier && this.wallpaper.equals(another.wallpaper) && this.unsave == another.unsave && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.wallpaper.hashCode();
        h += (h << 5) + Boolean.hashCode(this.unsave);
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "SaveWallPaper{identifier=" + this.identifier + ", wallpaper=" + this.wallpaper + ", unsave=" + this.unsave + ", settings=" + this.settings + "}";
    }

    public static ImmutableSaveWallPaper of(InputWallPaper wallpaper, boolean unsave, WallPaperSettings settings) {
        return new ImmutableSaveWallPaper(wallpaper, unsave, settings);
    }

    public static ImmutableSaveWallPaper copyOf(SaveWallPaper instance) {
        if (instance instanceof ImmutableSaveWallPaper) {
            return (ImmutableSaveWallPaper)instance;
        }
        return ImmutableSaveWallPaper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_WALLPAPER = 1L;
        private static final long INIT_BIT_UNSAVE = 2L;
        private static final long INIT_BIT_SETTINGS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputWallPaper wallpaper;
        private boolean unsave;
        private WallPaperSettings settings;

        private Builder() {
        }

        public final Builder from(SaveWallPaper instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SaveWallPaper instance;
            long bits = 0L;
            if (object instanceof SaveWallPaper) {
                instance = (SaveWallPaper)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.wallpaper(instance.wallpaper());
                this.unsave(instance.unsave());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder wallpaper(InputWallPaper wallpaper) {
            this.wallpaper = Objects.requireNonNull(wallpaper, "wallpaper");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder unsave(boolean unsave) {
            this.unsave = unsave;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder settings(WallPaperSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSaveWallPaper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSaveWallPaper(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("wallpaper");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("unsave");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build SaveWallPaper, some of required attributes are not set " + attributes;
        }
    }
}

