/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.CodeSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SendChangePhoneCode;

public final class ImmutableSendChangePhoneCode
implements SendChangePhoneCode {
    private final int identifier;
    private final String phoneNumber;
    private final CodeSettings settings;

    private ImmutableSendChangePhoneCode(String phoneNumber, CodeSettings settings) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = SendChangePhoneCode.super.identifier();
    }

    private ImmutableSendChangePhoneCode(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.settings = builder.settings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendChangePhoneCode.super.identifier();
    }

    private ImmutableSendChangePhoneCode(int identifier, String phoneNumber, CodeSettings settings) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.settings = settings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public CodeSettings settings() {
        return this.settings;
    }

    public final ImmutableSendChangePhoneCode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendChangePhoneCode(value, this.phoneNumber, this.settings);
    }

    public final ImmutableSendChangePhoneCode withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableSendChangePhoneCode(this.identifier, newValue, this.settings);
    }

    public final ImmutableSendChangePhoneCode withSettings(CodeSettings value) {
        if (this.settings == value) {
            return this;
        }
        CodeSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableSendChangePhoneCode(this.identifier, this.phoneNumber, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendChangePhoneCode && this.equalTo(0, (ImmutableSendChangePhoneCode)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendChangePhoneCode another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "SendChangePhoneCode{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", settings=" + this.settings + "}";
    }

    public static ImmutableSendChangePhoneCode of(String phoneNumber, CodeSettings settings) {
        return new ImmutableSendChangePhoneCode(phoneNumber, settings);
    }

    public static ImmutableSendChangePhoneCode copyOf(SendChangePhoneCode instance) {
        if (instance instanceof ImmutableSendChangePhoneCode) {
            return (ImmutableSendChangePhoneCode)instance;
        }
        return ImmutableSendChangePhoneCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_SETTINGS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private CodeSettings settings;

        private Builder() {
        }

        public final Builder from(SendChangePhoneCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendChangePhoneCode instance;
            long bits = 0L;
            if (object instanceof SendChangePhoneCode) {
                instance = (SendChangePhoneCode)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.phoneNumber(instance.phoneNumber());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder settings(CodeSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSendChangePhoneCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendChangePhoneCode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build SendChangePhoneCode, some of required attributes are not set " + attributes;
        }
    }
}

