/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.CodeSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SendConfirmPhoneCode;

public final class ImmutableSendConfirmPhoneCode
implements SendConfirmPhoneCode {
    private final int identifier;
    private final String hash;
    private final CodeSettings settings;

    private ImmutableSendConfirmPhoneCode(String hash, CodeSettings settings) {
        this.hash = Objects.requireNonNull(hash, "hash");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = SendConfirmPhoneCode.super.identifier();
    }

    private ImmutableSendConfirmPhoneCode(Builder builder) {
        this.hash = builder.hash;
        this.settings = builder.settings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendConfirmPhoneCode.super.identifier();
    }

    private ImmutableSendConfirmPhoneCode(int identifier, String hash, CodeSettings settings) {
        this.identifier = identifier;
        this.hash = hash;
        this.settings = settings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String hash() {
        return this.hash;
    }

    @Override
    public CodeSettings settings() {
        return this.settings;
    }

    public final ImmutableSendConfirmPhoneCode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendConfirmPhoneCode(value, this.hash, this.settings);
    }

    public final ImmutableSendConfirmPhoneCode withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableSendConfirmPhoneCode(this.identifier, newValue, this.settings);
    }

    public final ImmutableSendConfirmPhoneCode withSettings(CodeSettings value) {
        if (this.settings == value) {
            return this;
        }
        CodeSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableSendConfirmPhoneCode(this.identifier, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendConfirmPhoneCode && this.equalTo(0, (ImmutableSendConfirmPhoneCode)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendConfirmPhoneCode another) {
        return this.identifier == another.identifier && this.hash.equals(another.hash) && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "SendConfirmPhoneCode{identifier=" + this.identifier + ", hash=" + this.hash + ", settings=" + this.settings + "}";
    }

    public static ImmutableSendConfirmPhoneCode of(String hash, CodeSettings settings) {
        return new ImmutableSendConfirmPhoneCode(hash, settings);
    }

    public static ImmutableSendConfirmPhoneCode copyOf(SendConfirmPhoneCode instance) {
        if (instance instanceof ImmutableSendConfirmPhoneCode) {
            return (ImmutableSendConfirmPhoneCode)instance;
        }
        return ImmutableSendConfirmPhoneCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_SETTINGS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String hash;
        private CodeSettings settings;

        private Builder() {
        }

        public final Builder from(SendConfirmPhoneCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendConfirmPhoneCode instance;
            long bits = 0L;
            if (object instanceof SendConfirmPhoneCode) {
                instance = (SendConfirmPhoneCode)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder settings(CodeSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSendConfirmPhoneCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendConfirmPhoneCode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build SendConfirmPhoneCode, some of required attributes are not set " + attributes;
        }
    }
}

