/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SendVerifyEmailCode;

public final class ImmutableSendVerifyEmailCode
implements SendVerifyEmailCode {
    private final int identifier;
    private final String email;

    private ImmutableSendVerifyEmailCode(String email) {
        this.email = Objects.requireNonNull(email, "email");
        this.identifier = SendVerifyEmailCode.super.identifier();
    }

    private ImmutableSendVerifyEmailCode(Builder builder) {
        this.email = builder.email;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendVerifyEmailCode.super.identifier();
    }

    private ImmutableSendVerifyEmailCode(int identifier, String email) {
        this.identifier = identifier;
        this.email = email;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String email() {
        return this.email;
    }

    public final ImmutableSendVerifyEmailCode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendVerifyEmailCode(value, this.email);
    }

    public final ImmutableSendVerifyEmailCode withEmail(String value) {
        String newValue = Objects.requireNonNull(value, "email");
        if (this.email.equals(newValue)) {
            return this;
        }
        return new ImmutableSendVerifyEmailCode(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendVerifyEmailCode && this.equalTo(0, (ImmutableSendVerifyEmailCode)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendVerifyEmailCode another) {
        return this.identifier == another.identifier && this.email.equals(another.email);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.email.hashCode();
        return h;
    }

    public String toString() {
        return "SendVerifyEmailCode{identifier=" + this.identifier + ", email=" + this.email + "}";
    }

    public static ImmutableSendVerifyEmailCode of(String email) {
        return new ImmutableSendVerifyEmailCode(email);
    }

    public static ImmutableSendVerifyEmailCode copyOf(SendVerifyEmailCode instance) {
        if (instance instanceof ImmutableSendVerifyEmailCode) {
            return (ImmutableSendVerifyEmailCode)instance;
        }
        return ImmutableSendVerifyEmailCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMAIL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String email;

        private Builder() {
        }

        public final Builder from(SendVerifyEmailCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SendVerifyEmailCode instance;
            long bits = 0L;
            if (object instanceof SendVerifyEmailCode) {
                instance = (SendVerifyEmailCode)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.email(instance.email());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder email(String email) {
            this.email = Objects.requireNonNull(email, "email");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSendVerifyEmailCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendVerifyEmailCode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("email");
            }
            return "Cannot build SendVerifyEmailCode, some of required attributes are not set " + attributes;
        }
    }
}

