/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.CodeSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SendVerifyPhoneCode;

public final class ImmutableSendVerifyPhoneCode
implements SendVerifyPhoneCode {
    private final int identifier;
    private final String phoneNumber;
    private final CodeSettings settings;

    private ImmutableSendVerifyPhoneCode(String phoneNumber, CodeSettings settings) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = SendVerifyPhoneCode.super.identifier();
    }

    private ImmutableSendVerifyPhoneCode(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.settings = builder.settings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SendVerifyPhoneCode.super.identifier();
    }

    private ImmutableSendVerifyPhoneCode(int identifier, String phoneNumber, CodeSettings settings) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.settings = settings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public CodeSettings settings() {
        return this.settings;
    }

    public final ImmutableSendVerifyPhoneCode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSendVerifyPhoneCode(value, this.phoneNumber, this.settings);
    }

    public final ImmutableSendVerifyPhoneCode withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableSendVerifyPhoneCode(this.identifier, newValue, this.settings);
    }

    public final ImmutableSendVerifyPhoneCode withSettings(CodeSettings value) {
        if (this.settings == value) {
            return this;
        }
        CodeSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableSendVerifyPhoneCode(this.identifier, this.phoneNumber, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSendVerifyPhoneCode && this.equalTo(0, (ImmutableSendVerifyPhoneCode)another);
    }

    private boolean equalTo(int synthetic, ImmutableSendVerifyPhoneCode another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "SendVerifyPhoneCode{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", settings=" + this.settings + "}";
    }

    public static ImmutableSendVerifyPhoneCode of(String phoneNumber, CodeSettings settings) {
        return new ImmutableSendVerifyPhoneCode(phoneNumber, settings);
    }

    public static ImmutableSendVerifyPhoneCode copyOf(SendVerifyPhoneCode instance) {
        if (instance instanceof ImmutableSendVerifyPhoneCode) {
            return (ImmutableSendVerifyPhoneCode)instance;
        }
        return ImmutableSendVerifyPhoneCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_SETTINGS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private CodeSettings settings;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SendVerifyPhoneCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SendVerifyPhoneCode) {
                instance = (SendVerifyPhoneCode)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.phoneNumber(instance.phoneNumber());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder settings(CodeSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSendVerifyPhoneCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSendVerifyPhoneCode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build SendVerifyPhoneCode, some of required attributes are not set " + attributes;
        }
    }
}

