/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.AccountDaysTTL;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SetAccountTTL;

public final class ImmutableSetAccountTTL
implements SetAccountTTL {
    private final int identifier;
    private final AccountDaysTTL ttl;

    private ImmutableSetAccountTTL(AccountDaysTTL ttl) {
        this.ttl = Objects.requireNonNull(ttl, "ttl");
        this.identifier = SetAccountTTL.super.identifier();
    }

    private ImmutableSetAccountTTL(Builder builder) {
        this.ttl = builder.ttl;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetAccountTTL.super.identifier();
    }

    private ImmutableSetAccountTTL(int identifier, AccountDaysTTL ttl) {
        this.identifier = identifier;
        this.ttl = ttl;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public AccountDaysTTL ttl() {
        return this.ttl;
    }

    public final ImmutableSetAccountTTL withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetAccountTTL(value, this.ttl);
    }

    public final ImmutableSetAccountTTL withTtl(AccountDaysTTL value) {
        if (this.ttl == value) {
            return this;
        }
        AccountDaysTTL newValue = Objects.requireNonNull(value, "ttl");
        return new ImmutableSetAccountTTL(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetAccountTTL && this.equalTo(0, (ImmutableSetAccountTTL)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetAccountTTL another) {
        return this.identifier == another.identifier && this.ttl.equals(another.ttl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.ttl.hashCode();
        return h;
    }

    public String toString() {
        return "SetAccountTTL{identifier=" + this.identifier + ", ttl=" + this.ttl + "}";
    }

    public static ImmutableSetAccountTTL of(AccountDaysTTL ttl) {
        return new ImmutableSetAccountTTL(ttl);
    }

    public static ImmutableSetAccountTTL copyOf(SetAccountTTL instance) {
        if (instance instanceof ImmutableSetAccountTTL) {
            return (ImmutableSetAccountTTL)instance;
        }
        return ImmutableSetAccountTTL.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TTL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private AccountDaysTTL ttl;

        private Builder() {
        }

        public final Builder from(SetAccountTTL instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetAccountTTL instance;
            long bits = 0L;
            if (object instanceof SetAccountTTL) {
                instance = (SetAccountTTL)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.ttl(instance.ttl());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder ttl(AccountDaysTTL ttl) {
            this.ttl = Objects.requireNonNull(ttl, "ttl");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSetAccountTTL build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetAccountTTL(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ttl");
            }
            return "Cannot build SetAccountTTL, some of required attributes are not set " + attributes;
        }
    }
}

