/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SetAuthorizationTTL;

public final class ImmutableSetAuthorizationTTL
implements SetAuthorizationTTL {
    private final int identifier;
    private final int authorizationTtlDays;

    private ImmutableSetAuthorizationTTL(int authorizationTtlDays) {
        this.authorizationTtlDays = authorizationTtlDays;
        this.identifier = SetAuthorizationTTL.super.identifier();
    }

    private ImmutableSetAuthorizationTTL(Builder builder) {
        this.authorizationTtlDays = builder.authorizationTtlDays;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetAuthorizationTTL.super.identifier();
    }

    private ImmutableSetAuthorizationTTL(int identifier, int authorizationTtlDays) {
        this.identifier = identifier;
        this.authorizationTtlDays = authorizationTtlDays;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int authorizationTtlDays() {
        return this.authorizationTtlDays;
    }

    public final ImmutableSetAuthorizationTTL withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetAuthorizationTTL(value, this.authorizationTtlDays);
    }

    public final ImmutableSetAuthorizationTTL withAuthorizationTtlDays(int value) {
        if (this.authorizationTtlDays == value) {
            return this;
        }
        return new ImmutableSetAuthorizationTTL(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetAuthorizationTTL && this.equalTo(0, (ImmutableSetAuthorizationTTL)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetAuthorizationTTL another) {
        return this.identifier == another.identifier && this.authorizationTtlDays == another.authorizationTtlDays;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.authorizationTtlDays;
        return h;
    }

    public String toString() {
        return "SetAuthorizationTTL{identifier=" + this.identifier + ", authorizationTtlDays=" + this.authorizationTtlDays + "}";
    }

    public static ImmutableSetAuthorizationTTL of(int authorizationTtlDays) {
        return new ImmutableSetAuthorizationTTL(authorizationTtlDays);
    }

    public static ImmutableSetAuthorizationTTL copyOf(SetAuthorizationTTL instance) {
        if (instance instanceof ImmutableSetAuthorizationTTL) {
            return (ImmutableSetAuthorizationTTL)instance;
        }
        return ImmutableSetAuthorizationTTL.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_AUTHORIZATION_TTL_DAYS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int authorizationTtlDays;

        private Builder() {
        }

        public final Builder from(SetAuthorizationTTL instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetAuthorizationTTL instance;
            long bits = 0L;
            if (object instanceof SetAuthorizationTTL) {
                instance = (SetAuthorizationTTL)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.authorizationTtlDays(instance.authorizationTtlDays());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder authorizationTtlDays(int authorizationTtlDays) {
            this.authorizationTtlDays = authorizationTtlDays;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSetAuthorizationTTL build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetAuthorizationTTL(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authorizationTtlDays");
            }
            return "Cannot build SetAuthorizationTTL, some of required attributes are not set " + attributes;
        }
    }
}

