/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SetContentSettings;

public final class ImmutableSetContentSettings
implements SetContentSettings {
    private final int identifier;
    private final int flags;
    private final boolean sensitiveEnabled;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableSetContentSettings INSTANCE = ImmutableSetContentSettings.validate(new ImmutableSetContentSettings());

    private ImmutableSetContentSettings() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.sensitiveEnabled = this.initShim.sensitiveEnabled();
        this.initShim = null;
    }

    private ImmutableSetContentSettings(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.sensitiveEnabledIsSet()) {
            this.initShim.sensitiveEnabled(builder.sensitiveEnabled);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.sensitiveEnabled = this.initShim.sensitiveEnabled();
        this.initShim = null;
    }

    private ImmutableSetContentSettings(int identifier, int flags, boolean sensitiveEnabled) {
        this.identifier = identifier;
        this.flags = flags;
        this.sensitiveEnabled = sensitiveEnabled;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SetContentSettings.super.identifier();
    }

    private int flagsInitialize() {
        return SetContentSettings.super.flags();
    }

    private boolean sensitiveEnabledInitialize() {
        return SetContentSettings.super.sensitiveEnabled();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean sensitiveEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sensitiveEnabled() : this.sensitiveEnabled;
    }

    public final ImmutableSetContentSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableSetContentSettings.validate(new ImmutableSetContentSettings(value, this.flags, this.sensitiveEnabled));
    }

    public final ImmutableSetContentSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableSetContentSettings.validate(new ImmutableSetContentSettings(this.identifier, value, this.sensitiveEnabled));
    }

    public final ImmutableSetContentSettings withSensitiveEnabled(boolean value) {
        if (this.sensitiveEnabled == value) {
            return this;
        }
        return ImmutableSetContentSettings.validate(new ImmutableSetContentSettings(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetContentSettings && this.equalTo(0, (ImmutableSetContentSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetContentSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.sensitiveEnabled == another.sensitiveEnabled;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.sensitiveEnabled);
        return h;
    }

    public String toString() {
        return "SetContentSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", sensitiveEnabled=" + this.sensitiveEnabled + "}";
    }

    public static ImmutableSetContentSettings of() {
        return INSTANCE;
    }

    private static ImmutableSetContentSettings validate(ImmutableSetContentSettings instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableSetContentSettings copyOf(SetContentSettings instance) {
        if (instance instanceof ImmutableSetContentSettings) {
            return (ImmutableSetContentSettings)instance;
        }
        return ImmutableSetContentSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SENSITIVE_ENABLED = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean sensitiveEnabled;

        private Builder() {
        }

        public final Builder from(SetContentSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetContentSettings instance;
            long bits = 0L;
            if (object instanceof SetContentSettings) {
                instance = (SetContentSettings)object;
                this.flags(instance.flags());
                this.sensitiveEnabled(instance.sensitiveEnabled());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder sensitiveEnabled(boolean sensitiveEnabled) {
            this.sensitiveEnabled = sensitiveEnabled;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableSetContentSettings build() {
            return ImmutableSetContentSettings.validate(new ImmutableSetContentSettings(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean sensitiveEnabledIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte sensitiveEnabledBuildStage = 0;
        private boolean sensitiveEnabled;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSetContentSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSetContentSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean sensitiveEnabled() {
            if (this.sensitiveEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sensitiveEnabledBuildStage == 0) {
                this.sensitiveEnabledBuildStage = (byte)-1;
                this.sensitiveEnabled = ImmutableSetContentSettings.this.sensitiveEnabledInitialize();
                this.sensitiveEnabledBuildStage = 1;
            }
            return this.sensitiveEnabled;
        }

        void sensitiveEnabled(boolean sensitiveEnabled) {
            this.sensitiveEnabled = sensitiveEnabled;
            this.sensitiveEnabledBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.sensitiveEnabledBuildStage == -1) {
                attributes.add("sensitiveEnabled");
            }
            return "Cannot build SetContentSettings, attribute initializers form cycle " + attributes;
        }
    }
}

