/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.GlobalPrivacySettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SetGlobalPrivacySettings;

public final class ImmutableSetGlobalPrivacySettings
implements SetGlobalPrivacySettings {
    private final int identifier;
    private final GlobalPrivacySettings settings;

    private ImmutableSetGlobalPrivacySettings(GlobalPrivacySettings settings) {
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = SetGlobalPrivacySettings.super.identifier();
    }

    private ImmutableSetGlobalPrivacySettings(Builder builder) {
        this.settings = builder.settings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetGlobalPrivacySettings.super.identifier();
    }

    private ImmutableSetGlobalPrivacySettings(int identifier, GlobalPrivacySettings settings) {
        this.identifier = identifier;
        this.settings = settings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public GlobalPrivacySettings settings() {
        return this.settings;
    }

    public final ImmutableSetGlobalPrivacySettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetGlobalPrivacySettings(value, this.settings);
    }

    public final ImmutableSetGlobalPrivacySettings withSettings(GlobalPrivacySettings value) {
        if (this.settings == value) {
            return this;
        }
        GlobalPrivacySettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableSetGlobalPrivacySettings(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetGlobalPrivacySettings && this.equalTo(0, (ImmutableSetGlobalPrivacySettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetGlobalPrivacySettings another) {
        return this.identifier == another.identifier && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "SetGlobalPrivacySettings{identifier=" + this.identifier + ", settings=" + this.settings + "}";
    }

    public static ImmutableSetGlobalPrivacySettings of(GlobalPrivacySettings settings) {
        return new ImmutableSetGlobalPrivacySettings(settings);
    }

    public static ImmutableSetGlobalPrivacySettings copyOf(SetGlobalPrivacySettings instance) {
        if (instance instanceof ImmutableSetGlobalPrivacySettings) {
            return (ImmutableSetGlobalPrivacySettings)instance;
        }
        return ImmutableSetGlobalPrivacySettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SETTINGS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private GlobalPrivacySettings settings;

        private Builder() {
        }

        public final Builder from(SetGlobalPrivacySettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetGlobalPrivacySettings instance;
            long bits = 0L;
            if (object instanceof SetGlobalPrivacySettings) {
                instance = (SetGlobalPrivacySettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder settings(GlobalPrivacySettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSetGlobalPrivacySettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetGlobalPrivacySettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build SetGlobalPrivacySettings, some of required attributes are not set " + attributes;
        }
    }
}

