/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.InputPrivacyKey;
import telegram4j.tl.InputPrivacyRule;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.SetPrivacy;

public final class ImmutableSetPrivacy
implements SetPrivacy {
    private final int identifier;
    private final InputPrivacyKey key;
    private final List<InputPrivacyRule> rules;

    private ImmutableSetPrivacy(InputPrivacyKey key) {
        this.key = Objects.requireNonNull(key, "key");
        this.rules = Collections.emptyList();
        this.identifier = SetPrivacy.super.identifier();
    }

    private ImmutableSetPrivacy(Builder builder) {
        this.key = builder.key;
        this.rules = ImmutableSetPrivacy.createUnmodifiableList(true, builder.rules);
        this.identifier = builder.identifierIsSet() ? builder.identifier : SetPrivacy.super.identifier();
    }

    private ImmutableSetPrivacy(int identifier, InputPrivacyKey key, List<InputPrivacyRule> rules) {
        this.identifier = identifier;
        this.key = key;
        this.rules = rules;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPrivacyKey key() {
        return this.key;
    }

    @Override
    public List<InputPrivacyRule> rules() {
        return this.rules;
    }

    public final ImmutableSetPrivacy withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSetPrivacy(value, this.key, this.rules);
    }

    public final ImmutableSetPrivacy withKey(InputPrivacyKey value) {
        InputPrivacyKey newValue = Objects.requireNonNull(value, "key");
        if (this.key == newValue) {
            return this;
        }
        return new ImmutableSetPrivacy(this.identifier, newValue, this.rules);
    }

    public final ImmutableSetPrivacy withRules(InputPrivacyRule ... elements) {
        List<InputPrivacyRule> newValue = ImmutableSetPrivacy.createUnmodifiableList(false, ImmutableSetPrivacy.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSetPrivacy(this.identifier, this.key, newValue);
    }

    public final ImmutableSetPrivacy withRules(Iterable<? extends InputPrivacyRule> elements) {
        if (this.rules == elements) {
            return this;
        }
        List<InputPrivacyRule> newValue = ImmutableSetPrivacy.createUnmodifiableList(false, ImmutableSetPrivacy.createSafeList(elements, true, false));
        return new ImmutableSetPrivacy(this.identifier, this.key, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetPrivacy && this.equalTo(0, (ImmutableSetPrivacy)another);
    }

    private boolean equalTo(int synthetic, ImmutableSetPrivacy another) {
        return this.identifier == another.identifier && this.key.equals((Object)another.key) && this.rules.equals(another.rules);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.rules.hashCode();
        return h;
    }

    public String toString() {
        return "SetPrivacy{identifier=" + this.identifier + ", key=" + this.key + ", rules=" + this.rules + "}";
    }

    public static ImmutableSetPrivacy of(InputPrivacyKey key) {
        return new ImmutableSetPrivacy(key);
    }

    public static ImmutableSetPrivacy copyOf(SetPrivacy instance) {
        if (instance instanceof ImmutableSetPrivacy) {
            return (ImmutableSetPrivacy)instance;
        }
        return ImmutableSetPrivacy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPrivacyKey key;
        private List<InputPrivacyRule> rules = new ArrayList<InputPrivacyRule>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetPrivacy instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetPrivacy) {
                instance = (SetPrivacy)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllRules(instance.rules());
                this.key(instance.key());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder key(InputPrivacyKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addRule(InputPrivacyRule element) {
            this.rules.add(Objects.requireNonNull(element, "rules element"));
            return this;
        }

        public final Builder addRules(InputPrivacyRule ... elements) {
            for (InputPrivacyRule element : elements) {
                this.rules.add(Objects.requireNonNull(element, "rules element"));
            }
            return this;
        }

        public final Builder rules(Iterable<? extends InputPrivacyRule> elements) {
            this.rules.clear();
            return this.addAllRules(elements);
        }

        public final Builder addAllRules(Iterable<? extends InputPrivacyRule> elements) {
            for (InputPrivacyRule inputPrivacyRule : elements) {
                this.rules.add(Objects.requireNonNull(inputPrivacyRule, "rules element"));
            }
            return this;
        }

        public ImmutableSetPrivacy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetPrivacy(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build SetPrivacy, some of required attributes are not set " + attributes;
        }
    }
}

