/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.UnregisterDevice;

public final class ImmutableUnregisterDevice
implements UnregisterDevice {
    private final int identifier;
    private final int tokenType;
    private final String token;
    private final List<Long> otherUids;

    private ImmutableUnregisterDevice(int tokenType, String token) {
        this.tokenType = tokenType;
        this.token = Objects.requireNonNull(token, "token");
        this.otherUids = Collections.emptyList();
        this.identifier = UnregisterDevice.super.identifier();
    }

    private ImmutableUnregisterDevice(Builder builder) {
        this.tokenType = builder.tokenType;
        this.token = builder.token;
        this.otherUids = ImmutableUnregisterDevice.createUnmodifiableList(true, builder.otherUids);
        this.identifier = builder.identifierIsSet() ? builder.identifier : UnregisterDevice.super.identifier();
    }

    private ImmutableUnregisterDevice(int identifier, int tokenType, String token, List<Long> otherUids) {
        this.identifier = identifier;
        this.tokenType = tokenType;
        this.token = token;
        this.otherUids = otherUids;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int tokenType() {
        return this.tokenType;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public List<Long> otherUids() {
        return this.otherUids;
    }

    public final ImmutableUnregisterDevice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUnregisterDevice(value, this.tokenType, this.token, this.otherUids);
    }

    public final ImmutableUnregisterDevice withTokenType(int value) {
        if (this.tokenType == value) {
            return this;
        }
        return new ImmutableUnregisterDevice(this.identifier, value, this.token, this.otherUids);
    }

    public final ImmutableUnregisterDevice withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ImmutableUnregisterDevice(this.identifier, this.tokenType, newValue, this.otherUids);
    }

    public final ImmutableUnregisterDevice withOtherUids(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableUnregisterDevice.createUnmodifiableList(false, wrappedList);
        return new ImmutableUnregisterDevice(this.identifier, this.tokenType, this.token, newValue);
    }

    public final ImmutableUnregisterDevice withOtherUids(Iterable<Long> elements) {
        if (this.otherUids == elements) {
            return this;
        }
        List<Long> newValue = ImmutableUnregisterDevice.createUnmodifiableList(false, ImmutableUnregisterDevice.createSafeList(elements, true, false));
        return new ImmutableUnregisterDevice(this.identifier, this.tokenType, this.token, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUnregisterDevice && this.equalTo(0, (ImmutableUnregisterDevice)another);
    }

    private boolean equalTo(int synthetic, ImmutableUnregisterDevice another) {
        return this.identifier == another.identifier && this.tokenType == another.tokenType && this.token.equals(another.token) && this.otherUids.equals(another.otherUids);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.tokenType;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.otherUids.hashCode();
        return h;
    }

    public String toString() {
        return "UnregisterDevice{identifier=" + this.identifier + ", tokenType=" + this.tokenType + ", token=" + this.token + ", otherUids=" + this.otherUids + "}";
    }

    public static ImmutableUnregisterDevice of(int tokenType, String token) {
        return new ImmutableUnregisterDevice(tokenType, token);
    }

    public static ImmutableUnregisterDevice copyOf(UnregisterDevice instance) {
        if (instance instanceof ImmutableUnregisterDevice) {
            return (ImmutableUnregisterDevice)instance;
        }
        return ImmutableUnregisterDevice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TOKEN_TYPE = 1L;
        private static final long INIT_BIT_TOKEN = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int tokenType;
        private String token;
        private List<Long> otherUids = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UnregisterDevice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UnregisterDevice) {
                instance = (UnregisterDevice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.tokenType(instance.tokenType());
                this.addAllOtherUids(instance.otherUids());
                this.token(instance.token());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder tokenType(int tokenType) {
            this.tokenType = tokenType;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addOtherUid(long element) {
            this.otherUids.add(element);
            return this;
        }

        public final Builder addOtherUids(long ... elements) {
            for (long element : elements) {
                this.otherUids.add(element);
            }
            return this;
        }

        public final Builder otherUids(Iterable<Long> elements) {
            this.otherUids.clear();
            return this.addAllOtherUids(elements);
        }

        public final Builder addAllOtherUids(Iterable<Long> elements) {
            for (Long element : elements) {
                this.otherUids.add(Objects.requireNonNull(element, "otherUids element"));
            }
            return this;
        }

        public ImmutableUnregisterDevice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUnregisterDevice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tokenType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("token");
            }
            return "Cannot build UnregisterDevice, some of required attributes are not set " + attributes;
        }
    }
}

