/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.UpdateDeviceLocked;

public final class ImmutableUpdateDeviceLocked
implements UpdateDeviceLocked {
    private final int identifier;
    private final int period;

    private ImmutableUpdateDeviceLocked(int period) {
        this.period = period;
        this.identifier = UpdateDeviceLocked.super.identifier();
    }

    private ImmutableUpdateDeviceLocked(Builder builder) {
        this.period = builder.period;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateDeviceLocked.super.identifier();
    }

    private ImmutableUpdateDeviceLocked(int identifier, int period) {
        this.identifier = identifier;
        this.period = period;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int period() {
        return this.period;
    }

    public final ImmutableUpdateDeviceLocked withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateDeviceLocked(value, this.period);
    }

    public final ImmutableUpdateDeviceLocked withPeriod(int value) {
        if (this.period == value) {
            return this;
        }
        return new ImmutableUpdateDeviceLocked(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateDeviceLocked && this.equalTo(0, (ImmutableUpdateDeviceLocked)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateDeviceLocked another) {
        return this.identifier == another.identifier && this.period == another.period;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.period;
        return h;
    }

    public String toString() {
        return "UpdateDeviceLocked{identifier=" + this.identifier + ", period=" + this.period + "}";
    }

    public static ImmutableUpdateDeviceLocked of(int period) {
        return new ImmutableUpdateDeviceLocked(period);
    }

    public static ImmutableUpdateDeviceLocked copyOf(UpdateDeviceLocked instance) {
        if (instance instanceof ImmutableUpdateDeviceLocked) {
            return (ImmutableUpdateDeviceLocked)instance;
        }
        return ImmutableUpdateDeviceLocked.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PERIOD = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int period;

        private Builder() {
        }

        public final Builder from(UpdateDeviceLocked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UpdateDeviceLocked instance;
            long bits = 0L;
            if (object instanceof UpdateDeviceLocked) {
                instance = (UpdateDeviceLocked)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.period(instance.period());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder period(int period) {
            this.period = period;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateDeviceLocked build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateDeviceLocked(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("period");
            }
            return "Cannot build UpdateDeviceLocked, some of required attributes are not set " + attributes;
        }
    }
}

