/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputNotifyPeer;
import telegram4j.tl.InputPeerNotifySettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.UpdateNotifySettings;

public final class ImmutableUpdateNotifySettings
implements UpdateNotifySettings {
    private final int identifier;
    private final InputNotifyPeer peer;
    private final InputPeerNotifySettings settings;

    private ImmutableUpdateNotifySettings(InputNotifyPeer peer, InputPeerNotifySettings settings) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = UpdateNotifySettings.super.identifier();
    }

    private ImmutableUpdateNotifySettings(Builder builder) {
        this.peer = builder.peer;
        this.settings = builder.settings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateNotifySettings.super.identifier();
    }

    private ImmutableUpdateNotifySettings(int identifier, InputNotifyPeer peer, InputPeerNotifySettings settings) {
        this.identifier = identifier;
        this.peer = peer;
        this.settings = settings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputNotifyPeer peer() {
        return this.peer;
    }

    @Override
    public InputPeerNotifySettings settings() {
        return this.settings;
    }

    public final ImmutableUpdateNotifySettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateNotifySettings(value, this.peer, this.settings);
    }

    public final ImmutableUpdateNotifySettings withPeer(InputNotifyPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputNotifyPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableUpdateNotifySettings(this.identifier, newValue, this.settings);
    }

    public final ImmutableUpdateNotifySettings withSettings(InputPeerNotifySettings value) {
        if (this.settings == value) {
            return this;
        }
        InputPeerNotifySettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableUpdateNotifySettings(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateNotifySettings && this.equalTo(0, (ImmutableUpdateNotifySettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateNotifySettings another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateNotifySettings{identifier=" + this.identifier + ", peer=" + this.peer + ", settings=" + this.settings + "}";
    }

    public static ImmutableUpdateNotifySettings of(InputNotifyPeer peer, InputPeerNotifySettings settings) {
        return new ImmutableUpdateNotifySettings(peer, settings);
    }

    public static ImmutableUpdateNotifySettings copyOf(UpdateNotifySettings instance) {
        if (instance instanceof ImmutableUpdateNotifySettings) {
            return (ImmutableUpdateNotifySettings)instance;
        }
        return ImmutableUpdateNotifySettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_SETTINGS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputNotifyPeer peer;
        private InputPeerNotifySettings settings;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateNotifySettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateNotifySettings) {
                instance = (UpdateNotifySettings)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputNotifyPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder settings(InputPeerNotifySettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdateNotifySettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateNotifySettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build UpdateNotifySettings, some of required attributes are not set " + attributes;
        }
    }
}

