/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputCheckPasswordSRP;
import telegram4j.tl.account.PasswordInputSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.UpdatePasswordSettings;

public final class ImmutableUpdatePasswordSettings
implements UpdatePasswordSettings {
    private final int identifier;
    private final InputCheckPasswordSRP password;
    private final PasswordInputSettings newSettings;

    private ImmutableUpdatePasswordSettings(InputCheckPasswordSRP password, PasswordInputSettings newSettings) {
        this.password = Objects.requireNonNull(password, "password");
        this.newSettings = Objects.requireNonNull(newSettings, "newSettings");
        this.identifier = UpdatePasswordSettings.super.identifier();
    }

    private ImmutableUpdatePasswordSettings(Builder builder) {
        this.password = builder.password;
        this.newSettings = builder.newSettings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdatePasswordSettings.super.identifier();
    }

    private ImmutableUpdatePasswordSettings(int identifier, InputCheckPasswordSRP password, PasswordInputSettings newSettings) {
        this.identifier = identifier;
        this.password = password;
        this.newSettings = newSettings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputCheckPasswordSRP password() {
        return this.password;
    }

    @Override
    public PasswordInputSettings newSettings() {
        return this.newSettings;
    }

    public final ImmutableUpdatePasswordSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdatePasswordSettings(value, this.password, this.newSettings);
    }

    public final ImmutableUpdatePasswordSettings withPassword(InputCheckPasswordSRP value) {
        if (this.password == value) {
            return this;
        }
        InputCheckPasswordSRP newValue = Objects.requireNonNull(value, "password");
        return new ImmutableUpdatePasswordSettings(this.identifier, newValue, this.newSettings);
    }

    public final ImmutableUpdatePasswordSettings withNewSettings(PasswordInputSettings value) {
        if (this.newSettings == value) {
            return this;
        }
        PasswordInputSettings newValue = Objects.requireNonNull(value, "newSettings");
        return new ImmutableUpdatePasswordSettings(this.identifier, this.password, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdatePasswordSettings && this.equalTo(0, (ImmutableUpdatePasswordSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdatePasswordSettings another) {
        return this.identifier == another.identifier && this.password.equals(another.password) && this.newSettings.equals(another.newSettings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + this.newSettings.hashCode();
        return h;
    }

    public String toString() {
        return "UpdatePasswordSettings{identifier=" + this.identifier + ", password=" + this.password + ", newSettings=" + this.newSettings + "}";
    }

    public static ImmutableUpdatePasswordSettings of(InputCheckPasswordSRP password, PasswordInputSettings newSettings) {
        return new ImmutableUpdatePasswordSettings(password, newSettings);
    }

    public static ImmutableUpdatePasswordSettings copyOf(UpdatePasswordSettings instance) {
        if (instance instanceof ImmutableUpdatePasswordSettings) {
            return (ImmutableUpdatePasswordSettings)instance;
        }
        return ImmutableUpdatePasswordSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PASSWORD = 1L;
        private static final long INIT_BIT_NEW_SETTINGS = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputCheckPasswordSRP password;
        private PasswordInputSettings newSettings;

        private Builder() {
        }

        public final Builder from(UpdatePasswordSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UpdatePasswordSettings instance;
            long bits = 0L;
            if (object instanceof UpdatePasswordSettings) {
                instance = (UpdatePasswordSettings)object;
                this.newSettings(instance.newSettings());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.password(instance.password());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder password(InputCheckPasswordSRP password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder newSettings(PasswordInputSettings newSettings) {
            this.newSettings = Objects.requireNonNull(newSettings, "newSettings");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableUpdatePasswordSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdatePasswordSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("password");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("newSettings");
            }
            return "Cannot build UpdatePasswordSettings, some of required attributes are not set " + attributes;
        }
    }
}

