/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.UpdateProfile;

public final class ImmutableUpdateProfile
implements UpdateProfile {
    private final int identifier;
    private final int flags;
    @Nullable
    private final String firstName;
    @Nullable
    private final String lastName;
    @Nullable
    private final String about;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableUpdateProfile INSTANCE = ImmutableUpdateProfile.validate(new ImmutableUpdateProfile());

    private ImmutableUpdateProfile() {
        this.firstName = null;
        this.lastName = null;
        this.about = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateProfile(Builder builder) {
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.about = builder.about;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateProfile(int identifier, int flags, @Nullable String firstName, @Nullable String lastName, @Nullable String about) {
        this.identifier = identifier;
        this.flags = flags;
        this.firstName = firstName;
        this.lastName = lastName;
        this.about = about;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateProfile.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateProfile.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public String firstName() {
        return this.firstName;
    }

    @Override
    @Nullable
    public String lastName() {
        return this.lastName;
    }

    @Override
    @Nullable
    public String about() {
        return this.about;
    }

    public final ImmutableUpdateProfile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableUpdateProfile.validate(new ImmutableUpdateProfile(value, this.flags, this.firstName, this.lastName, this.about));
    }

    public final ImmutableUpdateProfile withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableUpdateProfile.validate(new ImmutableUpdateProfile(this.identifier, value, this.firstName, this.lastName, this.about));
    }

    public final ImmutableUpdateProfile withFirstName(@Nullable String value) {
        if (Objects.equals(this.firstName, value)) {
            return this;
        }
        return ImmutableUpdateProfile.validate(new ImmutableUpdateProfile(this.identifier, this.flags, value, this.lastName, this.about));
    }

    public final ImmutableUpdateProfile withLastName(@Nullable String value) {
        if (Objects.equals(this.lastName, value)) {
            return this;
        }
        return ImmutableUpdateProfile.validate(new ImmutableUpdateProfile(this.identifier, this.flags, this.firstName, value, this.about));
    }

    public final ImmutableUpdateProfile withAbout(@Nullable String value) {
        if (Objects.equals(this.about, value)) {
            return this;
        }
        return ImmutableUpdateProfile.validate(new ImmutableUpdateProfile(this.identifier, this.flags, this.firstName, this.lastName, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateProfile && this.equalTo(0, (ImmutableUpdateProfile)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateProfile another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.firstName, another.firstName) && Objects.equals(this.lastName, another.lastName) && Objects.equals(this.about, another.about);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.firstName);
        h += (h << 5) + Objects.hashCode(this.lastName);
        h += (h << 5) + Objects.hashCode(this.about);
        return h;
    }

    public String toString() {
        return "UpdateProfile{identifier=" + this.identifier + ", flags=" + this.flags + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", about=" + this.about + "}";
    }

    public static ImmutableUpdateProfile of() {
        return INSTANCE;
    }

    private static ImmutableUpdateProfile validate(ImmutableUpdateProfile instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableUpdateProfile copyOf(UpdateProfile instance) {
        if (instance instanceof ImmutableUpdateProfile) {
            return (ImmutableUpdateProfile)instance;
        }
        return ImmutableUpdateProfile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private String firstName;
        private String lastName;
        private String about;

        private Builder() {
        }

        public final Builder from(UpdateProfile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UpdateProfile instance;
            long bits = 0L;
            if (object instanceof UpdateProfile) {
                String lastNameValue;
                String firstNameValue;
                instance = (UpdateProfile)object;
                this.flags(instance.flags());
                String aboutValue = instance.about();
                if (aboutValue != null) {
                    this.about(aboutValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((firstNameValue = instance.firstName()) != null) {
                    this.firstName(firstNameValue);
                }
                if ((lastNameValue = instance.lastName()) != null) {
                    this.lastName(lastNameValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder firstName(@Nullable String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final Builder lastName(@Nullable String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final Builder about(@Nullable String about) {
            this.about = about;
            return this;
        }

        public ImmutableUpdateProfile build() {
            return ImmutableUpdateProfile.validate(new ImmutableUpdateProfile(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateProfile.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateProfile.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateProfile, attribute initializers form cycle " + attributes;
        }
    }
}

