/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.UpdateStatus;

public final class ImmutableUpdateStatus
implements UpdateStatus {
    private final int identifier;
    private final boolean offline;

    private ImmutableUpdateStatus(boolean offline) {
        this.offline = offline;
        this.identifier = UpdateStatus.super.identifier();
    }

    private ImmutableUpdateStatus(Builder builder) {
        this.offline = builder.offline;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UpdateStatus.super.identifier();
    }

    private ImmutableUpdateStatus(int identifier, boolean offline) {
        this.identifier = identifier;
        this.offline = offline;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public boolean offline() {
        return this.offline;
    }

    public final ImmutableUpdateStatus withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateStatus(value, this.offline);
    }

    public final ImmutableUpdateStatus withOffline(boolean value) {
        if (this.offline == value) {
            return this;
        }
        return new ImmutableUpdateStatus(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateStatus && this.equalTo(0, (ImmutableUpdateStatus)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateStatus another) {
        return this.identifier == another.identifier && this.offline == another.offline;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Boolean.hashCode(this.offline);
        return h;
    }

    public String toString() {
        return "UpdateStatus{identifier=" + this.identifier + ", offline=" + this.offline + "}";
    }

    public static ImmutableUpdateStatus of(boolean offline) {
        return new ImmutableUpdateStatus(offline);
    }

    public static ImmutableUpdateStatus copyOf(UpdateStatus instance) {
        if (instance instanceof ImmutableUpdateStatus) {
            return (ImmutableUpdateStatus)instance;
        }
        return ImmutableUpdateStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OFFLINE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private boolean offline;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof UpdateStatus) {
                instance = (UpdateStatus)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offline(instance.offline());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder offline(boolean offline) {
            this.offline = offline;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUpdateStatus build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateStatus(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("offline");
            }
            return "Cannot build UpdateStatus, some of required attributes are not set " + attributes;
        }
    }
}

