/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputDocument;
import telegram4j.tl.InputTheme;
import telegram4j.tl.InputThemeSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.UpdateTheme;

public final class ImmutableUpdateTheme
implements UpdateTheme {
    private final int identifier;
    private final int flags;
    private final String format;
    private final InputTheme theme;
    @Nullable
    private final String slug;
    @Nullable
    private final String title;
    @Nullable
    private final InputDocument document;
    @Nullable
    private final List<InputThemeSettings> settings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUpdateTheme(String format, InputTheme theme) {
        this.format = Objects.requireNonNull(format, "format");
        this.theme = Objects.requireNonNull(theme, "theme");
        this.slug = null;
        this.title = null;
        this.document = null;
        this.settings = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateTheme(Builder builder) {
        this.format = builder.format;
        this.theme = builder.theme;
        this.slug = builder.slug;
        this.title = builder.title;
        this.document = builder.document;
        List<InputThemeSettings> list = this.settings = builder.settings == null ? null : ImmutableUpdateTheme.createUnmodifiableList(true, builder.settings);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUpdateTheme(int identifier, int flags, String format, InputTheme theme, @Nullable String slug, @Nullable String title, @Nullable InputDocument document, @Nullable List<InputThemeSettings> settings) {
        this.identifier = identifier;
        this.flags = flags;
        this.format = format;
        this.theme = theme;
        this.slug = slug;
        this.title = title;
        this.document = document;
        this.settings = settings;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UpdateTheme.super.identifier();
    }

    private int flagsInitialize() {
        return UpdateTheme.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public InputTheme theme() {
        return this.theme;
    }

    @Override
    @Nullable
    public String slug() {
        return this.slug;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public InputDocument document() {
        return this.document;
    }

    @Override
    @Nullable
    public List<InputThemeSettings> settings() {
        return this.settings;
    }

    public final ImmutableUpdateTheme withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUpdateTheme(value, this.flags, this.format, this.theme, this.slug, this.title, this.document, this.settings);
    }

    public final ImmutableUpdateTheme withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUpdateTheme(this.identifier, value, this.format, this.theme, this.slug, this.title, this.document, this.settings);
    }

    public final ImmutableUpdateTheme withFormat(String value) {
        String newValue = Objects.requireNonNull(value, "format");
        if (this.format.equals(newValue)) {
            return this;
        }
        return new ImmutableUpdateTheme(this.identifier, this.flags, newValue, this.theme, this.slug, this.title, this.document, this.settings);
    }

    public final ImmutableUpdateTheme withTheme(InputTheme value) {
        if (this.theme == value) {
            return this;
        }
        InputTheme newValue = Objects.requireNonNull(value, "theme");
        return new ImmutableUpdateTheme(this.identifier, this.flags, this.format, newValue, this.slug, this.title, this.document, this.settings);
    }

    public final ImmutableUpdateTheme withSlug(@Nullable String value) {
        if (Objects.equals(this.slug, value)) {
            return this;
        }
        return new ImmutableUpdateTheme(this.identifier, this.flags, this.format, this.theme, value, this.title, this.document, this.settings);
    }

    public final ImmutableUpdateTheme withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableUpdateTheme(this.identifier, this.flags, this.format, this.theme, this.slug, value, this.document, this.settings);
    }

    public final ImmutableUpdateTheme withDocument(@Nullable InputDocument value) {
        if (this.document == value) {
            return this;
        }
        return new ImmutableUpdateTheme(this.identifier, this.flags, this.format, this.theme, this.slug, this.title, value, this.settings);
    }

    public final ImmutableUpdateTheme withSettings(InputThemeSettings ... elements) {
        if (elements == null) {
            return new ImmutableUpdateTheme(this.identifier, this.flags, this.format, this.theme, this.slug, this.title, this.document, null);
        }
        List<InputThemeSettings> newValue = Arrays.asList(elements) == null ? null : ImmutableUpdateTheme.createUnmodifiableList(false, ImmutableUpdateTheme.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUpdateTheme(this.identifier, this.flags, this.format, this.theme, this.slug, this.title, this.document, newValue);
    }

    public final ImmutableUpdateTheme withSettings(@Nullable Iterable<? extends InputThemeSettings> elements) {
        if (this.settings == elements) {
            return this;
        }
        List<InputThemeSettings> newValue = elements == null ? null : ImmutableUpdateTheme.createUnmodifiableList(false, ImmutableUpdateTheme.createSafeList(elements, true, false));
        return new ImmutableUpdateTheme(this.identifier, this.flags, this.format, this.theme, this.slug, this.title, this.document, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateTheme && this.equalTo(0, (ImmutableUpdateTheme)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateTheme another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.format.equals(another.format) && this.theme.equals(another.theme) && Objects.equals(this.slug, another.slug) && Objects.equals(this.title, another.title) && Objects.equals(this.document, another.document) && Objects.equals(this.settings, another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.format.hashCode();
        h += (h << 5) + this.theme.hashCode();
        h += (h << 5) + Objects.hashCode(this.slug);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.document);
        h += (h << 5) + Objects.hashCode(this.settings);
        return h;
    }

    public String toString() {
        return "UpdateTheme{identifier=" + this.identifier + ", flags=" + this.flags + ", format=" + this.format + ", theme=" + this.theme + ", slug=" + this.slug + ", title=" + this.title + ", document=" + this.document + ", settings=" + this.settings + "}";
    }

    public static ImmutableUpdateTheme of(String format, InputTheme theme) {
        return new ImmutableUpdateTheme(format, theme);
    }

    public static ImmutableUpdateTheme copyOf(UpdateTheme instance) {
        if (instance instanceof ImmutableUpdateTheme) {
            return (ImmutableUpdateTheme)instance;
        }
        return ImmutableUpdateTheme.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_FORMAT = 1L;
        private static final long INIT_BIT_THEME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private String format;
        private InputTheme theme;
        private String slug;
        private String title;
        private InputDocument document;
        private List<InputThemeSettings> settings = null;

        private Builder() {
        }

        public final Builder from(UpdateTheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UpdateTheme instance;
            long bits = 0L;
            if (object instanceof UpdateTheme) {
                String slugValue;
                InputDocument documentValue;
                List<InputThemeSettings> settingsValue;
                instance = (UpdateTheme)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((settingsValue = instance.settings()) != null) {
                    this.addAllSettings(settingsValue);
                }
                if ((documentValue = instance.document()) != null) {
                    this.document(documentValue);
                }
                this.flags(instance.flags());
                this.format(instance.format());
                this.theme(instance.theme());
                String titleValue = instance.title();
                if (titleValue != null) {
                    this.title(titleValue);
                }
                if ((slugValue = instance.slug()) != null) {
                    this.slug(slugValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder format(String format) {
            this.format = Objects.requireNonNull(format, "format");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder theme(InputTheme theme) {
            this.theme = Objects.requireNonNull(theme, "theme");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder slug(@Nullable String slug) {
            this.slug = slug;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder document(@Nullable InputDocument document) {
            this.document = document;
            return this;
        }

        public final Builder addSetting(InputThemeSettings element) {
            if (this.settings == null) {
                this.settings = new ArrayList<InputThemeSettings>();
            }
            this.settings.add(Objects.requireNonNull(element, "settings element"));
            return this;
        }

        public final Builder addSettings(InputThemeSettings ... elements) {
            if (this.settings == null) {
                this.settings = new ArrayList<InputThemeSettings>();
            }
            for (InputThemeSettings element : elements) {
                this.settings.add(Objects.requireNonNull(element, "settings element"));
            }
            return this;
        }

        public final Builder settings(@Nullable Iterable<? extends InputThemeSettings> elements) {
            if (elements == null) {
                this.settings = null;
                return this;
            }
            this.settings = new ArrayList<InputThemeSettings>();
            return this.addAllSettings(elements);
        }

        public final Builder addAllSettings(Iterable<? extends InputThemeSettings> elements) {
            Objects.requireNonNull(elements, "settings element");
            if (this.settings == null) {
                this.settings = new ArrayList<InputThemeSettings>();
            }
            for (InputThemeSettings inputThemeSettings : elements) {
                this.settings.add(Objects.requireNonNull(inputThemeSettings, "settings element"));
            }
            return this;
        }

        public ImmutableUpdateTheme build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUpdateTheme(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("format");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("theme");
            }
            return "Cannot build UpdateTheme, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUpdateTheme.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUpdateTheme.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UpdateTheme, attribute initializers form cycle " + attributes;
        }
    }
}

