/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFile;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.UploadRingtone;

public final class ImmutableUploadRingtone
implements UploadRingtone {
    private final int identifier;
    private final InputFile file;
    private final String fileName;
    private final String mimeType;

    private ImmutableUploadRingtone(InputFile file, String fileName, String mimeType) {
        this.file = Objects.requireNonNull(file, "file");
        this.fileName = Objects.requireNonNull(fileName, "fileName");
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
        this.identifier = UploadRingtone.super.identifier();
    }

    private ImmutableUploadRingtone(Builder builder) {
        this.file = builder.file;
        this.fileName = builder.fileName;
        this.mimeType = builder.mimeType;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UploadRingtone.super.identifier();
    }

    private ImmutableUploadRingtone(int identifier, InputFile file, String fileName, String mimeType) {
        this.identifier = identifier;
        this.file = file;
        this.fileName = fileName;
        this.mimeType = mimeType;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputFile file() {
        return this.file;
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    public final ImmutableUploadRingtone withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUploadRingtone(value, this.file, this.fileName, this.mimeType);
    }

    public final ImmutableUploadRingtone withFile(InputFile value) {
        if (this.file == value) {
            return this;
        }
        InputFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableUploadRingtone(this.identifier, newValue, this.fileName, this.mimeType);
    }

    public final ImmutableUploadRingtone withFileName(String value) {
        String newValue = Objects.requireNonNull(value, "fileName");
        if (this.fileName.equals(newValue)) {
            return this;
        }
        return new ImmutableUploadRingtone(this.identifier, this.file, newValue, this.mimeType);
    }

    public final ImmutableUploadRingtone withMimeType(String value) {
        String newValue = Objects.requireNonNull(value, "mimeType");
        if (this.mimeType.equals(newValue)) {
            return this;
        }
        return new ImmutableUploadRingtone(this.identifier, this.file, this.fileName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUploadRingtone && this.equalTo(0, (ImmutableUploadRingtone)another);
    }

    private boolean equalTo(int synthetic, ImmutableUploadRingtone another) {
        return this.identifier == another.identifier && this.file.equals(another.file) && this.fileName.equals(another.fileName) && this.mimeType.equals(another.mimeType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + this.fileName.hashCode();
        h += (h << 5) + this.mimeType.hashCode();
        return h;
    }

    public String toString() {
        return "UploadRingtone{identifier=" + this.identifier + ", file=" + this.file + ", fileName=" + this.fileName + ", mimeType=" + this.mimeType + "}";
    }

    public static ImmutableUploadRingtone of(InputFile file, String fileName, String mimeType) {
        return new ImmutableUploadRingtone(file, fileName, mimeType);
    }

    public static ImmutableUploadRingtone copyOf(UploadRingtone instance) {
        if (instance instanceof ImmutableUploadRingtone) {
            return (ImmutableUploadRingtone)instance;
        }
        return ImmutableUploadRingtone.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FILE = 1L;
        private static final long INIT_BIT_FILE_NAME = 2L;
        private static final long INIT_BIT_MIME_TYPE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputFile file;
        private String fileName;
        private String mimeType;

        private Builder() {
        }

        public final Builder from(UploadRingtone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UploadRingtone instance;
            long bits = 0L;
            if (object instanceof UploadRingtone) {
                instance = (UploadRingtone)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fileName(instance.fileName());
                this.file(instance.file());
                this.mimeType(instance.mimeType());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder file(InputFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fileName(String fileName) {
            this.fileName = Objects.requireNonNull(fileName, "fileName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder mimeType(String mimeType) {
            this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUploadRingtone build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUploadRingtone(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("file");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fileName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("mimeType");
            }
            return "Cannot build UploadRingtone, some of required attributes are not set " + attributes;
        }
    }
}

