/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputFile;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.UploadTheme;

public final class ImmutableUploadTheme
implements UploadTheme {
    private final int identifier;
    private final int flags;
    private final InputFile file;
    @Nullable
    private final InputFile thumb;
    private final String fileName;
    private final String mimeType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableUploadTheme(InputFile file, String fileName, String mimeType) {
        this.file = Objects.requireNonNull(file, "file");
        this.fileName = Objects.requireNonNull(fileName, "fileName");
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
        this.thumb = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUploadTheme(Builder builder) {
        this.file = builder.file;
        this.thumb = builder.thumb;
        this.fileName = builder.fileName;
        this.mimeType = builder.mimeType;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableUploadTheme(int identifier, int flags, InputFile file, @Nullable InputFile thumb, String fileName, String mimeType) {
        this.identifier = identifier;
        this.flags = flags;
        this.file = file;
        this.thumb = thumb;
        this.fileName = fileName;
        this.mimeType = mimeType;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return UploadTheme.super.identifier();
    }

    private int flagsInitialize() {
        return UploadTheme.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public InputFile file() {
        return this.file;
    }

    @Override
    @Nullable
    public InputFile thumb() {
        return this.thumb;
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    public final ImmutableUploadTheme withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUploadTheme(value, this.flags, this.file, this.thumb, this.fileName, this.mimeType);
    }

    public final ImmutableUploadTheme withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableUploadTheme(this.identifier, value, this.file, this.thumb, this.fileName, this.mimeType);
    }

    public final ImmutableUploadTheme withFile(InputFile value) {
        if (this.file == value) {
            return this;
        }
        InputFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableUploadTheme(this.identifier, this.flags, newValue, this.thumb, this.fileName, this.mimeType);
    }

    public final ImmutableUploadTheme withThumb(@Nullable InputFile value) {
        if (this.thumb == value) {
            return this;
        }
        return new ImmutableUploadTheme(this.identifier, this.flags, this.file, value, this.fileName, this.mimeType);
    }

    public final ImmutableUploadTheme withFileName(String value) {
        String newValue = Objects.requireNonNull(value, "fileName");
        if (this.fileName.equals(newValue)) {
            return this;
        }
        return new ImmutableUploadTheme(this.identifier, this.flags, this.file, this.thumb, newValue, this.mimeType);
    }

    public final ImmutableUploadTheme withMimeType(String value) {
        String newValue = Objects.requireNonNull(value, "mimeType");
        if (this.mimeType.equals(newValue)) {
            return this;
        }
        return new ImmutableUploadTheme(this.identifier, this.flags, this.file, this.thumb, this.fileName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUploadTheme && this.equalTo(0, (ImmutableUploadTheme)another);
    }

    private boolean equalTo(int synthetic, ImmutableUploadTheme another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.file.equals(another.file) && Objects.equals(this.thumb, another.thumb) && this.fileName.equals(another.fileName) && this.mimeType.equals(another.mimeType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + Objects.hashCode(this.thumb);
        h += (h << 5) + this.fileName.hashCode();
        h += (h << 5) + this.mimeType.hashCode();
        return h;
    }

    public String toString() {
        return "UploadTheme{identifier=" + this.identifier + ", flags=" + this.flags + ", file=" + this.file + ", thumb=" + this.thumb + ", fileName=" + this.fileName + ", mimeType=" + this.mimeType + "}";
    }

    public static ImmutableUploadTheme of(InputFile file, String fileName, String mimeType) {
        return new ImmutableUploadTheme(file, fileName, mimeType);
    }

    public static ImmutableUploadTheme copyOf(UploadTheme instance) {
        if (instance instanceof ImmutableUploadTheme) {
            return (ImmutableUploadTheme)instance;
        }
        return ImmutableUploadTheme.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FILE = 1L;
        private static final long INIT_BIT_FILE_NAME = 2L;
        private static final long INIT_BIT_MIME_TYPE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private InputFile file;
        private InputFile thumb;
        private String fileName;
        private String mimeType;

        private Builder() {
        }

        public final Builder from(UploadTheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UploadTheme instance;
            long bits = 0L;
            if (object instanceof UploadTheme) {
                instance = (UploadTheme)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fileName(instance.fileName());
                this.file(instance.file());
                this.mimeType(instance.mimeType());
                InputFile thumbValue = instance.thumb();
                if (thumbValue != null) {
                    this.thumb(thumbValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder file(InputFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder thumb(@Nullable InputFile thumb) {
            this.thumb = thumb;
            return this;
        }

        public final Builder fileName(String fileName) {
            this.fileName = Objects.requireNonNull(fileName, "fileName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder mimeType(String mimeType) {
            this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUploadTheme build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUploadTheme(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("file");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fileName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("mimeType");
            }
            return "Cannot build UploadTheme, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableUploadTheme.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableUploadTheme.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build UploadTheme, attribute initializers form cycle " + attributes;
        }
    }
}

