/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.InputFile;
import telegram4j.tl.WallPaperSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.UploadWallPaper;

public final class ImmutableUploadWallPaper
implements UploadWallPaper {
    private final int identifier;
    private final InputFile file;
    private final String mimeType;
    private final WallPaperSettings settings;

    private ImmutableUploadWallPaper(InputFile file, String mimeType, WallPaperSettings settings) {
        this.file = Objects.requireNonNull(file, "file");
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.identifier = UploadWallPaper.super.identifier();
    }

    private ImmutableUploadWallPaper(Builder builder) {
        this.file = builder.file;
        this.mimeType = builder.mimeType;
        this.settings = builder.settings;
        this.identifier = builder.identifierIsSet() ? builder.identifier : UploadWallPaper.super.identifier();
    }

    private ImmutableUploadWallPaper(int identifier, InputFile file, String mimeType, WallPaperSettings settings) {
        this.identifier = identifier;
        this.file = file;
        this.mimeType = mimeType;
        this.settings = settings;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputFile file() {
        return this.file;
    }

    @Override
    public String mimeType() {
        return this.mimeType;
    }

    @Override
    public WallPaperSettings settings() {
        return this.settings;
    }

    public final ImmutableUploadWallPaper withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableUploadWallPaper(value, this.file, this.mimeType, this.settings);
    }

    public final ImmutableUploadWallPaper withFile(InputFile value) {
        if (this.file == value) {
            return this;
        }
        InputFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableUploadWallPaper(this.identifier, newValue, this.mimeType, this.settings);
    }

    public final ImmutableUploadWallPaper withMimeType(String value) {
        String newValue = Objects.requireNonNull(value, "mimeType");
        if (this.mimeType.equals(newValue)) {
            return this;
        }
        return new ImmutableUploadWallPaper(this.identifier, this.file, newValue, this.settings);
    }

    public final ImmutableUploadWallPaper withSettings(WallPaperSettings value) {
        if (this.settings == value) {
            return this;
        }
        WallPaperSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutableUploadWallPaper(this.identifier, this.file, this.mimeType, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUploadWallPaper && this.equalTo(0, (ImmutableUploadWallPaper)another);
    }

    private boolean equalTo(int synthetic, ImmutableUploadWallPaper another) {
        return this.identifier == another.identifier && this.file.equals(another.file) && this.mimeType.equals(another.mimeType) && this.settings.equals(another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + this.mimeType.hashCode();
        h += (h << 5) + this.settings.hashCode();
        return h;
    }

    public String toString() {
        return "UploadWallPaper{identifier=" + this.identifier + ", file=" + this.file + ", mimeType=" + this.mimeType + ", settings=" + this.settings + "}";
    }

    public static ImmutableUploadWallPaper of(InputFile file, String mimeType, WallPaperSettings settings) {
        return new ImmutableUploadWallPaper(file, mimeType, settings);
    }

    public static ImmutableUploadWallPaper copyOf(UploadWallPaper instance) {
        if (instance instanceof ImmutableUploadWallPaper) {
            return (ImmutableUploadWallPaper)instance;
        }
        return ImmutableUploadWallPaper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FILE = 1L;
        private static final long INIT_BIT_MIME_TYPE = 2L;
        private static final long INIT_BIT_SETTINGS = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private InputFile file;
        private String mimeType;
        private WallPaperSettings settings;

        private Builder() {
        }

        public final Builder from(UploadWallPaper instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UploadWallPaper instance;
            long bits = 0L;
            if (object instanceof UploadWallPaper) {
                instance = (UploadWallPaper)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.file(instance.file());
                this.mimeType(instance.mimeType());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder file(InputFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder mimeType(String mimeType) {
            this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder settings(WallPaperSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUploadWallPaper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUploadWallPaper(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("file");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("mimeType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build UploadWallPaper, some of required attributes are not set " + attributes;
        }
    }
}

