/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.VerifyEmail;

public final class ImmutableVerifyEmail
implements VerifyEmail {
    private final int identifier;
    private final String email;
    private final String code;

    private ImmutableVerifyEmail(String email, String code) {
        this.email = Objects.requireNonNull(email, "email");
        this.code = Objects.requireNonNull(code, "code");
        this.identifier = VerifyEmail.super.identifier();
    }

    private ImmutableVerifyEmail(Builder builder) {
        this.email = builder.email;
        this.code = builder.code;
        this.identifier = builder.identifierIsSet() ? builder.identifier : VerifyEmail.super.identifier();
    }

    private ImmutableVerifyEmail(int identifier, String email, String code) {
        this.identifier = identifier;
        this.email = email;
        this.code = code;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String email() {
        return this.email;
    }

    @Override
    public String code() {
        return this.code;
    }

    public final ImmutableVerifyEmail withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableVerifyEmail(value, this.email, this.code);
    }

    public final ImmutableVerifyEmail withEmail(String value) {
        String newValue = Objects.requireNonNull(value, "email");
        if (this.email.equals(newValue)) {
            return this;
        }
        return new ImmutableVerifyEmail(this.identifier, newValue, this.code);
    }

    public final ImmutableVerifyEmail withCode(String value) {
        String newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals(newValue)) {
            return this;
        }
        return new ImmutableVerifyEmail(this.identifier, this.email, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVerifyEmail && this.equalTo(0, (ImmutableVerifyEmail)another);
    }

    private boolean equalTo(int synthetic, ImmutableVerifyEmail another) {
        return this.identifier == another.identifier && this.email.equals(another.email) && this.code.equals(another.code);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.email.hashCode();
        h += (h << 5) + this.code.hashCode();
        return h;
    }

    public String toString() {
        return "VerifyEmail{identifier=" + this.identifier + ", email=" + this.email + ", code=" + this.code + "}";
    }

    public static ImmutableVerifyEmail of(String email, String code) {
        return new ImmutableVerifyEmail(email, code);
    }

    public static ImmutableVerifyEmail copyOf(VerifyEmail instance) {
        if (instance instanceof ImmutableVerifyEmail) {
            return (ImmutableVerifyEmail)instance;
        }
        return ImmutableVerifyEmail.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMAIL = 1L;
        private static final long INIT_BIT_CODE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String email;
        private String code;

        private Builder() {
        }

        public final Builder from(VerifyEmail instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            VerifyEmail instance;
            long bits = 0L;
            if (object instanceof VerifyEmail) {
                instance = (VerifyEmail)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.email(instance.email());
                this.code(instance.code());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder email(String email) {
            this.email = Objects.requireNonNull(email, "email");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableVerifyEmail build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVerifyEmail(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("email");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("code");
            }
            return "Cannot build VerifyEmail, some of required attributes are not set " + attributes;
        }
    }
}

