/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.BindTempAuthKey;

public final class ImmutableBindTempAuthKey
implements BindTempAuthKey {
    private final int identifier;
    private final long permAuthKeyId;
    private final long nonce;
    private final int expiresAt;
    private final ByteBuf encryptedMessage;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBindTempAuthKey(long permAuthKeyId, long nonce, int expiresAt) {
        this.permAuthKeyId = permAuthKeyId;
        this.nonce = nonce;
        this.expiresAt = expiresAt;
        this.encryptedMessage = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBindTempAuthKey(Builder builder) {
        this.permAuthKeyId = builder.permAuthKeyId;
        this.nonce = builder.nonce;
        this.expiresAt = builder.expiresAt;
        this.encryptedMessage = builder.encryptedMessage_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBindTempAuthKey(int identifier, long permAuthKeyId, long nonce, int expiresAt, ByteBuf encryptedMessage) {
        this.identifier = identifier;
        this.permAuthKeyId = permAuthKeyId;
        this.nonce = nonce;
        this.expiresAt = expiresAt;
        this.encryptedMessage = encryptedMessage;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BindTempAuthKey.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long permAuthKeyId() {
        return this.permAuthKeyId;
    }

    @Override
    public long nonce() {
        return this.nonce;
    }

    @Override
    public int expiresAt() {
        return this.expiresAt;
    }

    @Override
    public ByteBuf encryptedMessage() {
        return this.encryptedMessage.duplicate();
    }

    public final ImmutableBindTempAuthKey withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBindTempAuthKey(value, this.permAuthKeyId, this.nonce, this.expiresAt, this.encryptedMessage);
    }

    public final ImmutableBindTempAuthKey withPermAuthKeyId(long value) {
        if (this.permAuthKeyId == value) {
            return this;
        }
        return new ImmutableBindTempAuthKey(this.identifier, value, this.nonce, this.expiresAt, this.encryptedMessage);
    }

    public final ImmutableBindTempAuthKey withNonce(long value) {
        if (this.nonce == value) {
            return this;
        }
        return new ImmutableBindTempAuthKey(this.identifier, this.permAuthKeyId, value, this.expiresAt, this.encryptedMessage);
    }

    public final ImmutableBindTempAuthKey withExpiresAt(int value) {
        if (this.expiresAt == value) {
            return this;
        }
        return new ImmutableBindTempAuthKey(this.identifier, this.permAuthKeyId, this.nonce, value, this.encryptedMessage);
    }

    public ImmutableBindTempAuthKey withEncryptedMessage(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.encryptedMessage == newValue) {
            return this;
        }
        return new ImmutableBindTempAuthKey(this.identifier, this.permAuthKeyId, this.nonce, this.expiresAt, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBindTempAuthKey && this.equalTo(0, (ImmutableBindTempAuthKey)another);
    }

    private boolean equalTo(int synthetic, ImmutableBindTempAuthKey another) {
        return this.identifier == another.identifier && this.permAuthKeyId == another.permAuthKeyId && this.nonce == another.nonce && this.expiresAt == another.expiresAt && this.encryptedMessage().equals((Object)another.encryptedMessage());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.permAuthKeyId);
        h += (h << 5) + Long.hashCode(this.nonce);
        h += (h << 5) + this.expiresAt;
        h += (h << 5) + this.encryptedMessage().hashCode();
        return h;
    }

    public String toString() {
        return "BindTempAuthKey{identifier=" + this.identifier + ", permAuthKeyId=" + this.permAuthKeyId + ", nonce=" + this.nonce + ", expiresAt=" + this.expiresAt + ", encryptedMessage=" + ByteBufUtil.hexDump((ByteBuf)this.encryptedMessage) + "}";
    }

    public static ImmutableBindTempAuthKey of(long permAuthKeyId, long nonce, int expiresAt) {
        return new ImmutableBindTempAuthKey(permAuthKeyId, nonce, expiresAt);
    }

    public static ImmutableBindTempAuthKey copyOf(BindTempAuthKey instance) {
        if (instance instanceof ImmutableBindTempAuthKey) {
            return (ImmutableBindTempAuthKey)instance;
        }
        return ImmutableBindTempAuthKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PERM_AUTH_KEY_ID = 1L;
        private static final long INIT_BIT_NONCE = 2L;
        private static final long INIT_BIT_EXPIRES_AT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf encryptedMessage_value = null;
        private int identifier;
        private long permAuthKeyId;
        private long nonce;
        private int expiresAt;

        private Builder() {
        }

        public final Builder from(BindTempAuthKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BindTempAuthKey instance;
            long bits = 0L;
            if (object instanceof BindTempAuthKey) {
                instance = (BindTempAuthKey)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.permAuthKeyId(instance.permAuthKeyId());
                this.encryptedMessage(instance.encryptedMessage());
                this.nonce(instance.nonce());
                this.expiresAt(instance.expiresAt());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder permAuthKeyId(long permAuthKeyId) {
            this.permAuthKeyId = permAuthKeyId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder nonce(long nonce) {
            this.nonce = nonce;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder expiresAt(int expiresAt) {
            this.expiresAt = expiresAt;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder encryptedMessage(ByteBuf value) {
            this.encryptedMessage_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableBindTempAuthKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBindTempAuthKey(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("permAuthKeyId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nonce");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("expiresAt");
            }
            return "Cannot build BindTempAuthKey, some of required attributes are not set " + attributes;
        }

        private ByteBuf encryptedMessage_build() {
            return Objects.requireNonNull(this.encryptedMessage_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBindTempAuthKey.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BindTempAuthKey, attribute initializers form cycle " + attributes;
        }
    }
}

