/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.CancelCode;

public final class ImmutableCancelCode
implements CancelCode {
    private final int identifier;
    private final String phoneNumber;
    private final String phoneCodeHash;

    private ImmutableCancelCode(String phoneNumber, String phoneCodeHash) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
        this.identifier = CancelCode.super.identifier();
    }

    private ImmutableCancelCode(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.phoneCodeHash = builder.phoneCodeHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : CancelCode.super.identifier();
    }

    private ImmutableCancelCode(int identifier, String phoneNumber, String phoneCodeHash) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.phoneCodeHash = phoneCodeHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String phoneCodeHash() {
        return this.phoneCodeHash;
    }

    public final ImmutableCancelCode withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCancelCode(value, this.phoneNumber, this.phoneCodeHash);
    }

    public final ImmutableCancelCode withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableCancelCode(this.identifier, newValue, this.phoneCodeHash);
    }

    public final ImmutableCancelCode withPhoneCodeHash(String value) {
        String newValue = Objects.requireNonNull(value, "phoneCodeHash");
        if (this.phoneCodeHash.equals(newValue)) {
            return this;
        }
        return new ImmutableCancelCode(this.identifier, this.phoneNumber, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCancelCode && this.equalTo(0, (ImmutableCancelCode)another);
    }

    private boolean equalTo(int synthetic, ImmutableCancelCode another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.phoneCodeHash.equals(another.phoneCodeHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.phoneCodeHash.hashCode();
        return h;
    }

    public String toString() {
        return "CancelCode{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", phoneCodeHash=" + this.phoneCodeHash + "}";
    }

    public static ImmutableCancelCode of(String phoneNumber, String phoneCodeHash) {
        return new ImmutableCancelCode(phoneNumber, phoneCodeHash);
    }

    public static ImmutableCancelCode copyOf(CancelCode instance) {
        if (instance instanceof ImmutableCancelCode) {
            return (ImmutableCancelCode)instance;
        }
        return ImmutableCancelCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_PHONE_CODE_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private String phoneCodeHash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CancelCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof CancelCode) {
                instance = (CancelCode)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phoneNumber(instance.phoneNumber());
                this.phoneCodeHash(instance.phoneCodeHash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder phoneCodeHash(String phoneCodeHash) {
            this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCancelCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCancelCode(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("phoneCodeHash");
            }
            return "Cannot build CancelCode, some of required attributes are not set " + attributes;
        }
    }
}

