/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.CheckRecoveryPassword;

public final class ImmutableCheckRecoveryPassword
implements CheckRecoveryPassword {
    private final int identifier;
    private final String code;

    private ImmutableCheckRecoveryPassword(String code) {
        this.code = Objects.requireNonNull(code, "code");
        this.identifier = CheckRecoveryPassword.super.identifier();
    }

    private ImmutableCheckRecoveryPassword(Builder builder) {
        this.code = builder.code;
        this.identifier = builder.identifierIsSet() ? builder.identifier : CheckRecoveryPassword.super.identifier();
    }

    private ImmutableCheckRecoveryPassword(int identifier, String code) {
        this.identifier = identifier;
        this.code = code;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String code() {
        return this.code;
    }

    public final ImmutableCheckRecoveryPassword withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCheckRecoveryPassword(value, this.code);
    }

    public final ImmutableCheckRecoveryPassword withCode(String value) {
        String newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckRecoveryPassword(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckRecoveryPassword && this.equalTo(0, (ImmutableCheckRecoveryPassword)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckRecoveryPassword another) {
        return this.identifier == another.identifier && this.code.equals(another.code);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.code.hashCode();
        return h;
    }

    public String toString() {
        return "CheckRecoveryPassword{identifier=" + this.identifier + ", code=" + this.code + "}";
    }

    public static ImmutableCheckRecoveryPassword of(String code) {
        return new ImmutableCheckRecoveryPassword(code);
    }

    public static ImmutableCheckRecoveryPassword copyOf(CheckRecoveryPassword instance) {
        if (instance instanceof ImmutableCheckRecoveryPassword) {
            return (ImmutableCheckRecoveryPassword)instance;
        }
        return ImmutableCheckRecoveryPassword.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String code;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CheckRecoveryPassword instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof CheckRecoveryPassword) {
                instance = (CheckRecoveryPassword)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.code(instance.code());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCheckRecoveryPassword build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckRecoveryPassword(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            return "Cannot build CheckRecoveryPassword, some of required attributes are not set " + attributes;
        }
    }
}

