/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.auth.DropTempAuthKeys;

public final class ImmutableDropTempAuthKeys
implements DropTempAuthKeys {
    private final int identifier;
    private final List<Long> exceptAuthKeys;

    private ImmutableDropTempAuthKeys(Builder builder) {
        this.exceptAuthKeys = ImmutableDropTempAuthKeys.createUnmodifiableList(true, builder.exceptAuthKeys);
        this.identifier = builder.identifierIsSet() ? builder.identifier : DropTempAuthKeys.super.identifier();
    }

    private ImmutableDropTempAuthKeys(int identifier, List<Long> exceptAuthKeys) {
        this.identifier = identifier;
        this.exceptAuthKeys = exceptAuthKeys;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Long> exceptAuthKeys() {
        return this.exceptAuthKeys;
    }

    public final ImmutableDropTempAuthKeys withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDropTempAuthKeys(value, this.exceptAuthKeys);
    }

    public final ImmutableDropTempAuthKeys withExceptAuthKeys(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableDropTempAuthKeys.createUnmodifiableList(false, wrappedList);
        return new ImmutableDropTempAuthKeys(this.identifier, newValue);
    }

    public final ImmutableDropTempAuthKeys withExceptAuthKeys(Iterable<Long> elements) {
        if (this.exceptAuthKeys == elements) {
            return this;
        }
        List<Long> newValue = ImmutableDropTempAuthKeys.createUnmodifiableList(false, ImmutableDropTempAuthKeys.createSafeList(elements, true, false));
        return new ImmutableDropTempAuthKeys(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDropTempAuthKeys && this.equalTo(0, (ImmutableDropTempAuthKeys)another);
    }

    private boolean equalTo(int synthetic, ImmutableDropTempAuthKeys another) {
        return this.identifier == another.identifier && this.exceptAuthKeys.equals(another.exceptAuthKeys);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.exceptAuthKeys.hashCode();
        return h;
    }

    public String toString() {
        return "DropTempAuthKeys{identifier=" + this.identifier + ", exceptAuthKeys=" + this.exceptAuthKeys + "}";
    }

    public static ImmutableDropTempAuthKeys copyOf(DropTempAuthKeys instance) {
        if (instance instanceof ImmutableDropTempAuthKeys) {
            return (ImmutableDropTempAuthKeys)instance;
        }
        return ImmutableDropTempAuthKeys.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Long> exceptAuthKeys = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(DropTempAuthKeys instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DropTempAuthKeys instance;
            long bits = 0L;
            if (object instanceof DropTempAuthKeys) {
                instance = (DropTempAuthKeys)object;
                this.addAllExceptAuthKeys(instance.exceptAuthKeys());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addExceptAuthKey(long element) {
            this.exceptAuthKeys.add(element);
            return this;
        }

        public final Builder addExceptAuthKeys(long ... elements) {
            for (long element : elements) {
                this.exceptAuthKeys.add(element);
            }
            return this;
        }

        public final Builder exceptAuthKeys(Iterable<Long> elements) {
            this.exceptAuthKeys.clear();
            return this.addAllExceptAuthKeys(elements);
        }

        public final Builder addAllExceptAuthKeys(Iterable<Long> elements) {
            for (Long element : elements) {
                this.exceptAuthKeys.add(Objects.requireNonNull(element, "exceptAuthKeys element"));
            }
            return this;
        }

        public ImmutableDropTempAuthKeys build() {
            return new ImmutableDropTempAuthKeys(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

